/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.ConfigUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageReader {
    private Map<String, String> entries = new HashMap<String, String>(128);
    private File file;

    public LanguageReader(File file, String defaultPath) {
        this.file = file;
        YamlConfiguration configFile = YamlConfiguration.loadConfiguration((File)file);
        Set keySet = configFile.getKeys(false);
        for (String key : keySet) {
            this.entries.put(key, configFile.getString(key));
        }
        this.check(defaultPath);
    }

    private void check(String defaultPath) {
        YamlConfiguration defaults = null;
        ConfigUpdater updater = null;
        InputStream resource = BreweryPlugin.getInstance().getResource(defaultPath);
        if (resource == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource));){
            String line;
            while ((line = reader.readLine()) != null) {
                String key;
                int index = line.indexOf(58);
                if (index == -1 || this.entries.containsKey(key = line.substring(0, index))) continue;
                if (defaults == null) {
                    defaults = new YamlConfiguration();
                    defaults.load((Reader)new BufferedReader(new InputStreamReader(Objects.requireNonNull(BreweryPlugin.getInstance().getResource(defaultPath)))));
                    updater = new ConfigUpdater(this.file);
                    updater.appendLines("", "# Updated");
                }
                this.entries.put(key, defaults.getString(key));
                updater.appendLines(line);
            }
            if (updater != null) {
                this.createBackup();
                updater.saveConfig();
                BreweryPlugin.getInstance().log("Language file updated");
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            BreweryPlugin.getInstance().errorLog("Language File could not be updated");
        }
    }

    private void createBackup() {
        File source = new File(this.file.getPath());
        String filePath = this.file.getPath();
        File backup = new File(filePath.substring(0, filePath.length() - 4) + "_old.yml");
        if (backup.exists()) {
            backup.delete();
        }
        source.renameTo(backup);
    }

    public String get(String key, String ... args) {
        String entry = this.entries.get(key);
        if (entry != null) {
            int i = 0;
            for (String arg : args) {
                if (arg == null) continue;
                entry = entry.replace("&v" + ++i, arg);
            }
        } else {
            entry = "%placeholder%";
        }
        return entry;
    }
}

