/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.LegacyUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataUpdater {
    private FileConfiguration data;
    private File file;
    private File worldFile;

    public DataUpdater(FileConfiguration data, File file, File worldFile) {
        this.data = data;
        this.file = file;
        this.worldFile = worldFile;
    }

    public void update(String fromVersion) {
        if (fromVersion.equalsIgnoreCase("1.0")) {
            this.update10();
            fromVersion = "1.1";
        }
        if (fromVersion.equalsIgnoreCase("1.1")) {
            this.update11();
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update10() {
        this.data.set("Version", (Object)"1.2");
        ConfigurationSection section = this.data.getConfigurationSection("Ingredients");
        try {
            if (section != null) {
                for (String id : section.getKeys(false)) {
                    ConfigurationSection matSection = section.getConfigurationSection(id + ".mats");
                    if (matSection != null) {
                        HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
                        for (String ingredient : matSection.getKeys(false)) {
                            Material mat = LegacyUtil.getMaterial(BreweryPlugin.getInstance().parseInt(ingredient));
                            if (mat == null) continue;
                            ingredients.put(mat.name(), matSection.getInt(ingredient));
                        }
                        section.set(id + ".mats", ingredients);
                        continue;
                    }
                    BreweryPlugin.getInstance().errorLog("Ingredient id: '" + id + "' incomplete in data.yml");
                }
            }
        }
        catch (Exception e) {
            BreweryPlugin.getInstance().errorLog("Error Converting Ingredient Section of the Data File, newer versions of Bukkit may not support the old Save File anymore:");
            e.printStackTrace();
        }
        section = this.data.getConfigurationSection("BCauldron");
        if (section != null) {
            try {
                for (String uuid : section.getKeys(false)) {
                    ConfigurationSection cauldrons = section.getConfigurationSection(uuid);
                    if (cauldrons == null) continue;
                    for (String id : cauldrons.getKeys(false)) {
                        ConfigurationSection ingredientSection = cauldrons.getConfigurationSection(id + ".ingredients");
                        if (ingredientSection != null) {
                            HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
                            for (String ingredient : ingredientSection.getKeys(false)) {
                                Material mat = LegacyUtil.getMaterial(BreweryPlugin.getInstance().parseInt(ingredient));
                                if (mat == null) continue;
                                ingredients.put(mat.name(), ingredientSection.getInt(ingredient));
                            }
                            cauldrons.set(id + ".ingredients", ingredients);
                            continue;
                        }
                        BreweryPlugin.getInstance().errorLog("BCauldron " + id + " is missing Ingredient Section");
                    }
                }
            }
            catch (Exception e) {
                BreweryPlugin.getInstance().errorLog("Error Converting Ingredient Section of Cauldrons, newer versions of Bukkit may not support the old Save File anymore:");
                e.printStackTrace();
            }
        }
    }

    public void update11() {
        this.data.set("Version", (Object)"1.2");
        YamlConfiguration worldData = new YamlConfiguration();
        if (this.data.contains("BCauldron")) {
            worldData.set("BCauldron", this.data.get("BCauldron"));
            this.data.set("BCauldron", null);
        }
        if (this.data.contains("Barrel")) {
            worldData.set("Barrel", this.data.get("Barrel"));
            this.data.set("Barrel", null);
        }
        if (this.data.contains("Wakeup")) {
            worldData.set("Wakeup", this.data.get("Wakeup"));
            this.data.set("Wakeup", null);
        }
        if (this.data.contains("Worlds")) {
            worldData.set("Worlds", this.data.get("Worlds"));
            this.data.set("Worlds", null);
        }
        try {
            worldData.save(this.worldFile);
            File bkup = new File(BreweryPlugin.getInstance().getDataFolder(), "dataBackup.yml");
            if (bkup.exists()) {
                bkup.renameTo(new File(BreweryPlugin.getInstance().getDataFolder(), "worlddataBackup.yml"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

