/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.filedata.BData;
import com.dre.brewery.filedata.ReadOldData;
import com.dre.brewery.filedata.WriteData;
import com.dre.brewery.integration.universalScheduler.UniversalRunnable;
import com.dre.brewery.utility.BUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DataSave
extends UniversalRunnable {
    public static int lastBackup = 0;
    public static int lastSave = 1;
    public static int autosave = 3;
    public static final String dataVersion = "1.2";
    public static DataSave running;
    public static List<World> unloadingWorlds;
    public ReadOldData read;
    private final long time;
    private final List<World> loadedWorlds;
    public boolean collected = false;

    public DataSave(ReadOldData read) {
        this.read = read;
        this.time = System.currentTimeMillis();
        this.loadedWorlds = BreweryPlugin.getInstance().getServer().getWorlds();
    }

    @Override
    public void run() {
        try {
            YamlConfiguration oldWorldData;
            long saveTime = System.nanoTime();
            if (this.read != null) {
                if (!this.read.done) {
                    if (System.currentTimeMillis() - this.time > 50000L) {
                        BreweryPlugin.getInstance().errorLog("Old Data took too long to load! Mutex: " + BData.dataMutex.get());
                        try {
                            this.cancel();
                            this.read.cancel();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        running = null;
                        BData.dataMutex.set(0);
                    }
                    return;
                }
                oldWorldData = this.read.getData();
            } else {
                oldWorldData = new YamlConfiguration();
            }
            try {
                this.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            BData.worldData = null;
            YamlConfiguration data = new YamlConfiguration();
            YamlConfiguration worldData = new YamlConfiguration();
            data.set("installTime", (Object)Brew.installTime);
            data.set("MCBarrelTime", (Object)MCBarrel.mcBarrelTime);
            Brew.writePrevSeeds((ConfigurationSection)data);
            ArrayList<Integer> brewsCreated = new ArrayList<Integer>(7);
            brewsCreated.add(BreweryPlugin.getInstance().stats.brewsCreated);
            brewsCreated.add(BreweryPlugin.getInstance().stats.brewsCreatedCmd);
            brewsCreated.add(BreweryPlugin.getInstance().stats.exc);
            brewsCreated.add(BreweryPlugin.getInstance().stats.good);
            brewsCreated.add(BreweryPlugin.getInstance().stats.norm);
            brewsCreated.add(BreweryPlugin.getInstance().stats.bad);
            brewsCreated.add(BreweryPlugin.getInstance().stats.terr);
            data.set("brewsCreated", brewsCreated);
            data.set("brewsCreatedH", (Object)brewsCreated.hashCode());
            if (!Brew.legacyPotions.isEmpty()) {
                Brew.saveLegacy(data.createSection("Brew"));
            }
            if (!BPlayer.isEmpty()) {
                BPlayer.save(data.createSection("Player"));
            }
            if (!BCauldron.bcauldrons.isEmpty() || oldWorldData.contains("BCauldron")) {
                BCauldron.save(worldData.createSection("BCauldron"), oldWorldData.getConfigurationSection("BCauldron"));
            }
            if (!Barrel.barrels.isEmpty() || oldWorldData.contains("Barrel")) {
                Barrel.save(worldData.createSection("Barrel"), oldWorldData.getConfigurationSection("Barrel"));
            }
            if (!Wakeup.wakeups.isEmpty() || oldWorldData.contains("Wakeup")) {
                Wakeup.save(worldData.createSection("Wakeup"), oldWorldData.getConfigurationSection("Wakeup"));
            }
            this.saveWorldNames((FileConfiguration)worldData, oldWorldData.getConfigurationSection("Worlds"));
            data.set("Version", (Object)dataVersion);
            this.collected = true;
            if (!unloadingWorlds.isEmpty()) {
                try {
                    for (World world : unloadingWorlds) {
                        Barrel.onUnload(world);
                        BCauldron.onUnload(world);
                        Wakeup.onUnload(world);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                unloadingWorlds.clear();
            }
            BreweryPlugin.getInstance().debugLog("saving: " + (double)(System.nanoTime() - saveTime) / 1000000.0 + "ms");
            if (BreweryPlugin.getInstance().isEnabled()) {
                BreweryPlugin.getScheduler().runTaskAsynchronously(new WriteData((FileConfiguration)data, (FileConfiguration)worldData));
            } else {
                new WriteData((FileConfiguration)data, (FileConfiguration)worldData).run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BData.dataMutex.set(0);
        }
    }

    public void saveWorldNames(FileConfiguration root, ConfigurationSection old) {
        if (old != null) {
            root.set("Worlds", (Object)old);
        }
        for (World world : this.loadedWorlds) {
            String worldName = world.getName();
            if (worldName.startsWith("DXL_")) {
                worldName = BUtil.getDxlName(worldName);
                root.set("Worlds." + worldName, (Object)0);
                continue;
            }
            worldName = world.getUID().toString();
            root.set("Worlds." + worldName, (Object)world.getName());
        }
    }

    public void now() {
        if (!this.read.done) {
            this.read.cancel();
            this.read.run();
        }
        if (!this.collected) {
            this.cancel();
            this.run();
        }
    }

    public static void save(boolean collectInstant) {
        if (running != null) {
            BreweryPlugin.getInstance().log("Another Save was started while a Save was in Progress");
            if (collectInstant) {
                running.now();
            }
            return;
        }
        ReadOldData read = new ReadOldData();
        if (collectInstant) {
            read.run();
            running = new DataSave(read);
            running.run();
        } else {
            read.runTaskAsynchronously((Plugin)BreweryPlugin.getInstance());
            running = new DataSave(read);
            running.runTaskTimer((Plugin)BreweryPlugin.getInstance(), 1L, 2L);
        }
    }

    public static void autoSave() {
        if (lastSave >= autosave) {
            DataSave.save(false);
        } else {
            ++lastSave;
        }
    }

    static {
        unloadingWorlds = new CopyOnWriteArrayList<World>();
    }
}

