/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BCauldron;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.filedata.BConfig;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class ReloadCommand
implements SubCommand {
    private final BreweryPlugin breweryPlugin;

    public ReloadCommand(BreweryPlugin breweryPlugin) {
        this.breweryPlugin = breweryPlugin;
    }

    @Override
    public void execute(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        FileConfiguration cfg;
        if (sender != null && !sender.equals(Bukkit.getConsoleSender())) {
            BConfig.reloader = sender;
        }
        if ((cfg = BConfig.loadConfigFile()) == null) {
            breweryPlugin.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        breweryPlugin.clearConfigData();
        try {
            BConfig.readConfig(cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
            breweryPlugin.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        BCauldron.reload();
        CommandUtil.reloadTabCompleter();
        boolean successful = true;
        for (Brew brew : Brew.legacyPotions.values()) {
            if (brew.reloadRecipe()) continue;
            successful = false;
        }
        if (sender != null) {
            if (!successful) {
                breweryPlugin.msg(sender, breweryPlugin.languageReader.get("Error_Recipeload", new String[0]));
            } else {
                breweryPlugin.msg(sender, breweryPlugin.languageReader.get("CMD_Reload", new String[0]));
            }
        }
        new AddonManager(breweryPlugin).reloadAddons();
        BConfig.reloader = null;
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.reload";
    }

    @Override
    public boolean playerOnly() {
        return false;
    }
}

