/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BPlayer;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoCommand
implements SubCommand {
    private final BreweryPlugin breweryPlugin;

    public InfoCommand(BreweryPlugin breweryPlugin) {
        this.breweryPlugin = breweryPlugin;
    }

    @Override
    public void execute(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        if (args.length > 1) {
            if (sender.hasPermission("brewery.cmd.infoOther")) {
                this.cmdInfo(sender, args[1]);
            } else {
                breweryPlugin.msg(sender, breweryPlugin.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (sender.hasPermission("brewery.cmd.info")) {
            this.cmdInfo(sender, null);
        } else {
            breweryPlugin.msg(sender, breweryPlugin.languageReader.get("Error_NoPermissions", new String[0]));
        }
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.info";
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    public void cmdInfo(CommandSender sender, String playerName) {
        BPlayer bPlayer;
        Player player;
        boolean selfInfo;
        boolean bl = selfInfo = playerName == null;
        if (selfInfo) {
            if (sender instanceof Player) {
                player = (Player)sender;
                playerName = player.getName();
            } else {
                this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("Error_PlayerCommand", new String[0]));
                return;
            }
        }
        if ((bPlayer = (player = BreweryPlugin.getInstance().getServer().getPlayerExact(playerName)) == null ? BPlayer.getByName(playerName) : BPlayer.get(player)) == null) {
            this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("CMD_Info_NotDrunk", playerName));
        } else if (selfInfo) {
            bPlayer.showDrunkeness(player);
        } else {
            this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("CMD_Info_Drunk", playerName, "" + bPlayer.getDrunkeness(), "" + bPlayer.getQuality()));
        }
    }
}

