/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CopyCommand
implements SubCommand {
    private final BreweryPlugin breweryPlugin;

    public CopyCommand(BreweryPlugin breweryPlugin) {
        this.breweryPlugin = breweryPlugin;
    }

    @Override
    public void execute(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        if (args.length > 1) {
            this.cmdCopy(sender, breweryPlugin.parseInt(args[1]));
        } else {
            this.cmdCopy(sender, 1);
        }
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.copy";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    public void cmdCopy(CommandSender sender, int count) {
        if (count < 1 || count > 36) {
            this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("Etc_Usage", new String[0]));
            this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("Help_Copy", new String[0]));
            return;
        }
        Player player = (Player)sender;
        ItemStack hand = player.getItemInHand();
        if (hand != null && Brew.isBrew(hand)) {
            while (count > 0) {
                ItemStack item = hand.clone();
                if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                    this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("CMD_Copy_Error", "" + count));
                    return;
                }
                --count;
            }
            return;
        }
        this.breweryPlugin.msg(sender, this.breweryPlugin.languageReader.get("Error_ItemNotPotion", new String[0]));
    }
}

