/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.events;

import com.dre.brewery.BCauldron;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.LegacyUtil;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IngedientAddEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Block block;
    private final BCauldron cauldron;
    private ItemStack ingredient;
    private RecipeItem rItem;
    private boolean cancelled;
    private boolean takeItem = true;

    public IngedientAddEvent(Player who, Block block, BCauldron bCauldron, ItemStack ingredient, RecipeItem rItem) {
        super(who);
        this.block = block;
        this.cauldron = bCauldron;
        this.rItem = rItem;
        this.ingredient = ingredient;
    }

    public Block getBlock() {
        return this.block;
    }

    public BCauldron getCauldron() {
        return this.cauldron;
    }

    public RecipeItem getRecipeItem() {
        return this.rItem;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(ItemStack ingredient) {
        this.ingredient = ingredient;
        this.rItem = RecipeItem.getMatchingRecipeItem(ingredient, true);
    }

    public boolean willTakeItem() {
        return this.takeItem;
    }

    public void setTakeItem(boolean takeItem) {
        this.takeItem = takeItem;
    }

    @Nullable
    public Levelled getCauldronData() {
        BlockData data = this.block.getBlockData();
        if (data instanceof Levelled) {
            return (Levelled)data;
        }
        return null;
    }

    public byte getFillLevel() {
        return LegacyUtil.getFillLevel(this.block);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

