/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonLogger;
import com.dre.brewery.api.addons.BreweryAddon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.bukkit.configuration.file.YamlConfiguration;

public class AddonFileManager {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private final BreweryAddon addon;
    private final String addonName;
    private final File addonFolder;
    private final AddonLogger logger;
    private final File configFile;
    private YamlConfiguration addonConfig;
    private final File jarFile;

    public AddonFileManager(BreweryAddon addon, File jarFile) {
        this.addon = addon;
        this.jarFile = jarFile;
        this.addonName = addon.getClass().getSimpleName();
        this.addonFolder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "addons" + File.separator + this.addonName);
        this.logger = addon.getLogger();
        this.configFile = new File(this.addonFolder, this.addonName + ".yml");
        this.addonConfig = this.configFile.exists() ? YamlConfiguration.loadConfiguration((File)this.configFile) : null;
    }

    public void generateFile(String fileName) {
        this.generateFile(new File(this.addonFolder, fileName));
    }

    public void generateFileAbsPath(String absolutePath) {
        this.generateFile(new File(absolutePath));
    }

    public void generateFile(File parent, String fileName) {
        this.generateFile(new File(parent, fileName));
    }

    public void generateFile(File file) {
        block9: {
            this.createAddonFolder();
            try {
                if (file.exists()) break block9;
                file.createNewFile();
                try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.jarFile));){
                    JarEntry jarEntry;
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        int bytesRead;
                        if (jarEntry.isDirectory() || !jarEntry.getName().equals(file.getName())) continue;
                        OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        outputStream.flush();
                        outputStream.close();
                        break;
                    }
                }
            }
            catch (IOException ex) {
                this.logger.severe("Failed to generate file " + file.getName(), ex);
            }
        }
    }

    public File getFile(String fileName) {
        this.createAddonFolder();
        return new File(this.addonFolder, fileName);
    }

    public YamlConfiguration getYamlConfiguration(String fileName) {
        this.createAddonFolder();
        return YamlConfiguration.loadConfiguration((File)new File(this.addonFolder, fileName));
    }

    public File getAddonFolder() {
        return this.addonFolder;
    }

    public YamlConfiguration getAddonConfig() {
        this.generateAddonConfig();
        return this.addonConfig;
    }

    public void saveAddonConfig() {
        this.generateAddonConfig();
        try {
            this.addonConfig.save(this.configFile);
        }
        catch (IOException ex) {
            this.logger.severe("Failed to save addon config", ex);
        }
    }

    private void generateAddonConfig() {
        if (this.addonConfig == null) {
            this.generateFile(this.configFile);
            this.addonConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        }
    }

    private void createAddonFolder() {
        if (!this.addonFolder.exists()) {
            this.addonFolder.mkdirs();
        }
    }
}

