/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class BreweryApi {
    public static int getApiVersion() {
        return 3;
    }

    public static boolean removeAny(Block block) {
        if (BreweryApi.removeCauldron(block)) {
            return true;
        }
        return BreweryApi.removeBarrel(block, true);
    }

    public static boolean removeAnyByPlayer(Block block, Player player) {
        if (BreweryApi.removeCauldron(block)) {
            return true;
        }
        return BreweryApi.removeBarrelByPlayer(block, player, true);
    }

    public static BPlayer getBPlayer(Player player) {
        return BPlayer.get(player);
    }

    public static void setPlayerDrunk(Player player, int drunkeness, int quality) {
        if (drunkeness < 0) {
            throw new IllegalArgumentException("Drunkeness can not be <0");
        }
        if (quality > 10) {
            throw new IllegalArgumentException("Quality can not be >10");
        }
        BPlayer bPlayer = BPlayer.get(player);
        if (bPlayer == null && player != null) {
            if (drunkeness == 0) {
                return;
            }
            bPlayer = BPlayer.addPlayer(player);
        }
        if (bPlayer == null) {
            return;
        }
        if (drunkeness == 0) {
            bPlayer.remove();
        } else {
            bPlayer.setData(drunkeness, quality);
        }
        if (drunkeness > 100) {
            if (player != null) {
                bPlayer.drinkCap(player);
            } else if (!BConfig.overdrinkKick) {
                bPlayer.setData(100, 0);
            }
        }
    }

    @Nullable
    public static Brew getBrew(ItemStack item) {
        return Brew.get(item);
    }

    @Nullable
    public static Brew getBrew(ItemMeta meta) {
        return Brew.get(meta);
    }

    public static boolean isBrew(ItemStack item) {
        return Brew.isBrew(item);
    }

    @Nullable
    public static Brew createBrew(String recipeName, int quality) {
        BRecipe matching = BRecipe.getMatching(recipeName);
        if (matching != null) {
            return matching.createBrew(quality);
        }
        return null;
    }

    public static Brew createBrew(BRecipe recipe, int quality) {
        return recipe.createBrew(quality);
    }

    @Nullable
    public static ItemStack createBrewItem(String recipeName, int quality) {
        BRecipe matching = BRecipe.getMatching(recipeName);
        if (matching != null) {
            return matching.create(quality);
        }
        return null;
    }

    public static ItemStack createBrewItem(BRecipe recipe, int quality) {
        return recipe.create(quality);
    }

    @Nullable
    public static String getRecipeName(ItemStack item) {
        Brew brew = Brew.get(item);
        if (brew != null) {
            return BreweryApi.getRecipeName(brew);
        }
        return null;
    }

    @Nullable
    public static String getRecipeName(Brew brew) {
        BRecipe recipe = brew.getCurrentRecipe();
        if (recipe != null) {
            return recipe.getRecipeName();
        }
        return null;
    }

    @Nullable
    public static Barrel getBarrel(Block block) {
        return Barrel.get(block);
    }

    @Nullable
    public static Inventory getBarrelInventory(Block block) {
        Barrel barrel = Barrel.get(block);
        if (barrel != null) {
            return barrel.getInventory();
        }
        return null;
    }

    public static boolean removeBarrel(Block block, boolean dropItems) {
        return BreweryApi.removeBarrelByPlayer(block, null, dropItems);
    }

    public static boolean removeBarrelByPlayer(Block block, Player player, boolean dropItems) {
        Barrel barrel = Barrel.get(block);
        if (barrel != null) {
            barrel.remove(block, player, dropItems);
            return true;
        }
        return false;
    }

    @Nullable
    public static BCauldron getCauldron(Block block) {
        return BCauldron.get(block);
    }

    public static boolean removeCauldron(Block block) {
        return BCauldron.remove(block);
    }

    @Nullable
    public static BRecipe getRecipe(String name) {
        return BRecipe.get(name);
    }

    @Nullable
    public static BRecipe getRecipeMatch(String name) {
        return BRecipe.getMatching(name);
    }

    public static void addRecipe(BRecipe recipe, boolean saveForever) {
        if (saveForever) {
            throw new UnsupportedOperationException("SaveForever is not implemented yet");
        }
        BRecipe.getAddedRecipes().add(recipe);
        recipe.updateAcceptedLists();
    }

    @Nullable
    public static BRecipe removeRecipe(String name) {
        List<BRecipe> recipes = BRecipe.getAllRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).getRecipeName().equalsIgnoreCase(name)) continue;
            BRecipe remove = recipes.remove(i);
            if (i < BRecipe.numConfigRecipes) {
                --BRecipe.numConfigRecipes;
            }
            return remove;
        }
        return null;
    }

    public static BRecipe.Builder recipeBuilder(String ... recipeNames) {
        return new BRecipe.Builder(recipeNames);
    }

    @Nullable
    public static BCauldronRecipe getCauldronRecipe(String name) {
        return BCauldronRecipe.get(name);
    }

    public static void addCauldronRecipe(BCauldronRecipe recipe, boolean saveForever) {
        if (saveForever) {
            throw new UnsupportedOperationException();
        }
        BCauldronRecipe.getAddedRecipes().add(recipe);
        recipe.updateAcceptedLists();
    }

    @Nullable
    public static BCauldronRecipe removeCauldronRecipe(String name) {
        List<BCauldronRecipe> recipes = BCauldronRecipe.getAllRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).getName().equalsIgnoreCase(name)) continue;
            BCauldronRecipe remove = recipes.remove(i);
            if (i < BCauldronRecipe.numConfigRecipes) {
                --BCauldronRecipe.numConfigRecipes;
            }
            return remove;
        }
        return null;
    }

    public static BCauldronRecipe.Builder cauldronRecipeBuilder(String name) {
        return new BCauldronRecipe.Builder(name);
    }
}

