/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.DistortChat;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandManager;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.filedata.BData;
import com.dre.brewery.filedata.DataSave;
import com.dre.brewery.filedata.LanguageReader;
import com.dre.brewery.filedata.UpdateChecker;
import com.dre.brewery.integration.ChestShopListener;
import com.dre.brewery.integration.IntegrationListener;
import com.dre.brewery.integration.ShopKeepersListener;
import com.dre.brewery.integration.SlimefunListener;
import com.dre.brewery.integration.barrel.BlocklockerBarrel;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.integration.universalScheduler.UniversalScheduler;
import com.dre.brewery.integration.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.dre.brewery.listeners.BlockListener;
import com.dre.brewery.listeners.CauldronListener;
import com.dre.brewery.listeners.EntityListener;
import com.dre.brewery.listeners.InventoryListener;
import com.dre.brewery.listeners.PlayerListener;
import com.dre.brewery.listeners.WorldListener;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.LegacyUtil;
import com.dre.brewery.utility.Stats;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BreweryPlugin
extends JavaPlugin {
    private static AddonManager addonManager;
    private static TaskScheduler scheduler;
    private static BreweryPlugin breweryPlugin;
    public static boolean debug;
    public static boolean useUUID;
    public static boolean useNBT;
    public static boolean use1_9;
    public static boolean use1_11;
    public static boolean use1_13;
    public static boolean use1_14;
    public PlayerListener playerListener;
    public Map<String, Function<ItemLoader, Ingredient>> ingredientLoaders = new HashMap<String, Function<ItemLoader, Ingredient>>();
    public String language;
    public LanguageReader languageReader;
    public Stats stats = new Stats();

    public void onEnable() {
        breweryPlugin = this;
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        String v = Bukkit.getBukkitVersion();
        useUUID = !v.matches("(^|.*[^.\\d])1\\.[0-6]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.7\\.[0-5]([^\\d].*|$)");
        use1_9 = !v.matches("(^|.*[^.\\d])1\\.[0-8]([^\\d].*|$)");
        use1_11 = !v.matches("(^|.*[^.\\d])1\\.10([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        use1_13 = !v.matches("(^|.*[^.\\d])1\\.1[0-2]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        use1_14 = !v.matches("(^|.*[^.\\d])1\\.1[0-3]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        addonManager = new AddonManager(this);
        addonManager.loadAddons();
        if (LegacyUtil.initNbt()) {
            useNBT = true;
        }
        if (use1_14) {
            this.getServer().createBlockData(Material.CAMPFIRE);
        }
        try {
            FileConfiguration cfg = BConfig.loadConfigFile();
            if (cfg == null) {
                this.log("Something went wrong when trying to load the config file! Please check your config.yml");
                return;
            }
            BConfig.readConfig(cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        CustomItem.registerItemLoader(this);
        SimpleItem.registerItemLoader(this);
        PluginItem.registerItemLoader(this);
        BData.readData();
        this.stats.setupBStats();
        this.getCommand("brewery").setExecutor((CommandExecutor)new CommandManager());
        this.playerListener = new PlayerListener();
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new IntegrationListener(), (Plugin)this);
        if (use1_9) {
            this.getServer().getPluginManager().registerEvents((Listener)new CauldronListener(), (Plugin)this);
        }
        if (BConfig.hasChestShop && use1_13) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChestShopListener(), (Plugin)this);
        }
        if (BConfig.hasShopKeepers) {
            this.getServer().getPluginManager().registerEvents((Listener)new ShopKeepersListener(), (Plugin)this);
        }
        if (BConfig.hasSlimefun && use1_14) {
            this.getServer().getPluginManager().registerEvents((Listener)new SlimefunListener(), (Plugin)this);
        }
        BreweryPlugin.getScheduler().runTaskTimer(new BreweryRunnable(), 650L, 1200L);
        BreweryPlugin.getScheduler().runTaskTimer(new DrunkRunnable(), 120L, 120L);
        if (use1_9) {
            BreweryPlugin.getScheduler().runTaskTimer(new CauldronParticles(), 1L, 1L);
        }
        if (use1_14 && BConfig.updateCheck) {
            new UpdateChecker(114777).query(latestVersion -> {
                int pluginVersion = this.parseInt(this.getDescription().getVersion().replace(".", "").strip());
                int latest = this.parseInt(latestVersion.replace(".", "").strip());
                if (latest > pluginVersion) {
                    UpdateChecker.setUpdateAvailable(true);
                    UpdateChecker.setLatestVersion(latestVersion);
                    this.msg((CommandSender)Bukkit.getConsoleSender(), this.languageReader.get("Etc_UpdateAvailable", "v" + this.getDescription().getVersion(), "v" + latestVersion));
                }
            });
        }
        this.debugLog("Using scheduler: " + scheduler.getClass().getSimpleName());
        this.log(this.getDescription().getName() + " enabled!");
    }

    public void onDisable() {
        addonManager.unloadAddons();
        HandlerList.unregisterAll((Plugin)this);
        BreweryPlugin.getScheduler().cancelTasks((Plugin)this);
        if (breweryPlugin == null) {
            return;
        }
        DataSave.save(true);
        if (BConfig.sqlSync != null) {
            try {
                BConfig.sqlSync.closeConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            BConfig.sqlSync = null;
        }
        this.clearConfigData();
        this.log(this.getDescription().getName() + " disabled!");
    }

    public void reload(CommandSender sender) {
        FileConfiguration cfg;
        if (sender != null && !sender.equals(this.getServer().getConsoleSender())) {
            BConfig.reloader = sender;
        }
        if ((cfg = BConfig.loadConfigFile()) == null) {
            this.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        this.clearConfigData();
        try {
            BConfig.readConfig(cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        BCauldron.reload();
        CommandUtil.reloadTabCompleter();
        boolean successful = true;
        for (Brew brew : Brew.legacyPotions.values()) {
            if (brew.reloadRecipe()) continue;
            successful = false;
        }
        if (sender != null) {
            if (!successful) {
                this.msg(sender, BreweryPlugin.breweryPlugin.languageReader.get("Error_Recipeload", new String[0]));
            } else {
                breweryPlugin.msg(sender, BreweryPlugin.breweryPlugin.languageReader.get("CMD_Reload", new String[0]));
            }
        }
        BConfig.reloader = null;
    }

    public void clearConfigData() {
        BRecipe.getConfigRecipes().clear();
        BRecipe.numConfigRecipes = 0;
        BCauldronRecipe.acceptedMaterials.clear();
        BCauldronRecipe.acceptedCustom.clear();
        BCauldronRecipe.acceptedSimple.clear();
        BCauldronRecipe.getConfigRecipes().clear();
        BCauldronRecipe.numConfigRecipes = 0;
        BConfig.customItems.clear();
        BConfig.hasMMOItems = null;
        DistortChat.commands = null;
        BConfig.drainItems.clear();
        if (BConfig.useLB) {
            try {
                LogBlockBarrel.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerForItemLoader(String saveID, Function<ItemLoader, Ingredient> loadFct) {
        this.ingredientLoaders.put(saveID, loadFct);
    }

    public void unRegisterItemLoader(String saveID) {
        this.ingredientLoaders.remove(saveID);
    }

    public static BreweryPlugin getInstance() {
        return breweryPlugin;
    }

    public void msg(CommandSender sender, String msg) {
        sender.sendMessage(this.color(BConfig.pluginPrefix + msg));
    }

    public void log(String msg) {
        this.msg((CommandSender)Bukkit.getConsoleSender(), msg);
    }

    public void debugLog(String msg) {
        if (debug) {
            this.msg((CommandSender)Bukkit.getConsoleSender(), "&2[Debug] &f" + msg);
        }
    }

    public void errorLog(String msg) {
        Bukkit.getConsoleSender().sendMessage(this.color(BConfig.pluginPrefix + "&cERROR: " + msg));
        if (BConfig.reloader != null) {
            BConfig.reloader.sendMessage(this.color(BConfig.pluginPrefix + "&cERROR: " + msg));
        }
    }

    public int parseInt(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    public double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0;
        }
    }

    public float parseFloat(String string) {
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0f;
        }
    }

    public String color(String msg) {
        return BUtil.color(msg);
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public class BreweryRunnable
    implements Runnable {
        @Override
        public void run() {
            long t1 = System.nanoTime();
            BConfig.reloader = null;
            Iterator<BCauldron> bCauldronsToRemove = BCauldron.bcauldrons.values().iterator();
            while (bCauldronsToRemove.hasNext()) {
                BCauldron bCauldron = bCauldronsToRemove.next();
                BreweryPlugin.getScheduler().runTask(bCauldron.getBlock().getLocation(), () -> {
                    if (!bCauldron.onUpdate()) {
                        bCauldronsToRemove.remove();
                    }
                });
            }
            long t2 = System.nanoTime();
            Barrel.onUpdate();
            long t3 = System.nanoTime();
            if (use1_14) {
                MCBarrel.onUpdate();
            }
            if (BConfig.useBlocklocker) {
                BlocklockerBarrel.clearBarrelSign();
            }
            long t4 = System.nanoTime();
            BPlayer.onUpdate();
            long t5 = System.nanoTime();
            DataSave.autoSave();
            long t6 = System.nanoTime();
            BreweryPlugin.this.debugLog("BreweryRunnable: t1: " + (double)(t2 - t1) / 1000000.0 + "ms | t2: " + (double)(t3 - t2) / 1000000.0 + "ms | t3: " + (double)(t4 - t3) / 1000000.0 + "ms | t4: " + (double)(t5 - t4) / 1000000.0 + "ms | t5: " + (double)(t6 - t5) / 1000000.0 + "ms");
        }
    }

    public static class DrunkRunnable
    implements Runnable {
        @Override
        public void run() {
            if (!BPlayer.isEmpty()) {
                BPlayer.drunkeness();
            }
        }
    }

    public class CauldronParticles
    implements Runnable {
        @Override
        public void run() {
            if (!BConfig.enableCauldronParticles) {
                return;
            }
            if (BConfig.minimalParticles && BCauldron.particleRandom.nextFloat() > 0.5f) {
                return;
            }
            BCauldron.processCookEffects();
        }
    }
}

