/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Barrel;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.LegacyUtil;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class BarrelBody {
    private final Barrel barrel;
    private final Block spigot;
    private BoundingBox bounds;
    private byte signoffset;

    public BarrelBody(Barrel barrel, byte signoffset) {
        this.barrel = barrel;
        this.signoffset = signoffset;
        this.spigot = barrel.getSpigot();
        this.bounds = new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public BarrelBody(Barrel barrel, byte signoffset, BoundingBox bounds, boolean async) {
        this(barrel, signoffset);
        if (BarrelBody.boundsSeemBad(bounds)) {
            if (async) {
                this.bounds = null;
                return;
            }
            this.regenerateBounds();
        } else {
            this.bounds = bounds;
        }
    }

    public Barrel getBarrel() {
        return this.barrel;
    }

    public Block getSpigot() {
        return this.spigot;
    }

    @NotNull
    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setBounds(@NotNull BoundingBox bounds) {
        Objects.requireNonNull(bounds);
        this.bounds = bounds;
    }

    public byte getSignoffset() {
        return this.signoffset;
    }

    public void setSignoffset(byte signoffset) {
        this.signoffset = signoffset;
    }

    public void destroySign() {
        this.signoffset = 0;
    }

    public static boolean boundsSeemBad(BoundingBox bounds) {
        if (bounds == null) {
            return true;
        }
        long area = bounds.area();
        return area > 64L || area < 4L;
    }

    public static int getDirection(Block spigot) {
        int direction = 0;
        Material type = spigot.getRelative(0, 0, 1).getType();
        if (LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) {
            direction = 3;
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(0, 0, -1).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 4;
            } else {
                return 0;
            }
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(1, 0, 0).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 1;
            } else {
                return 0;
            }
        }
        if (LegacyUtil.isWoodPlanks(type = spigot.getRelative(-1, 0, 0).getType()) || LegacyUtil.isWoodStairs(type)) {
            if (direction == 0) {
                direction = 2;
            } else {
                return 0;
            }
        }
        return direction;
    }

    public boolean isLarge() {
        return this.barrel.isLarge();
    }

    public boolean isSmall() {
        return this.barrel.isSmall();
    }

    public byte getWood() {
        Block wood;
        switch (BarrelBody.getDirection(this.spigot)) {
            case 0: {
                return 0;
            }
            case 1: {
                wood = this.spigot.getRelative(1, 0, 0);
                break;
            }
            case 2: {
                wood = this.spigot.getRelative(-1, 0, 0);
                break;
            }
            case 3: {
                wood = this.spigot.getRelative(0, 0, 1);
                break;
            }
            default: {
                wood = this.spigot.getRelative(0, 0, -1);
            }
        }
        try {
            return LegacyUtil.getWoodType(wood);
        }
        catch (NoClassDefFoundError | NoSuchFieldError noSuchFieldError) {
            return 0;
        }
    }

    public boolean hasBlock(Block block) {
        if (block != null) {
            if (this.spigot.equals(block)) {
                return true;
            }
            if (this.spigot.getWorld().equals(block.getWorld())) {
                return this.bounds != null && this.bounds.contains(block.getX(), block.getY(), block.getZ());
            }
        }
        return false;
    }

    public boolean isSignOfBarrel(byte offset) {
        return offset == 0 || this.signoffset == 0 || this.signoffset == offset;
    }

    public Block getSignOfSpigot() {
        if (this.signoffset != 0) {
            if (LegacyUtil.isSign(this.spigot.getType())) {
                return this.spigot;
            }
            if (LegacyUtil.isSign(this.spigot.getRelative(0, (int)this.signoffset, 0).getType())) {
                return this.spigot.getRelative(0, (int)this.signoffset, 0);
            }
            this.signoffset = 0;
        }
        return this.spigot;
    }

    public static Block getSpigotOfSign(Block block) {
        for (int y = -2; y <= 1; ++y) {
            Block relative = block.getRelative(0, y, 0);
            if (!LegacyUtil.isFence(relative.getType())) continue;
            return relative;
        }
        return block;
    }

    public boolean regenerateBounds() {
        BreweryPlugin.getInstance().log("Regenerating Barrel BoundingBox: " + (String)(this.bounds == null ? "was null" : "area=" + this.bounds.area()));
        Block broken = this.getBrokenBlock(true);
        if (broken != null) {
            this.barrel.remove(broken, null, true);
            return false;
        }
        return true;
    }

    public Block getBrokenBlock(boolean force) {
        if (force || BUtil.isChunkLoaded(this.spigot)) {
            if (LegacyUtil.isSign(this.spigot.getType())) {
                return this.checkSBarrel();
            }
            return this.checkLBarrel();
        }
        return null;
    }

    public Block checkSBarrel() {
        int startZ;
        int startX;
        int direction = BarrelBody.getDirection(this.spigot);
        if (direction == 0) {
            return this.spigot;
        }
        if (direction == 1) {
            startX = 1;
            startZ = -1;
        } else if (direction == 2) {
            startX = -2;
            startZ = 0;
        } else if (direction == 3) {
            startX = 0;
            startZ = 1;
        } else {
            startX = -1;
            startZ = -2;
        }
        int endX = startX + 1;
        int endZ = startZ + 1;
        int x = startX;
        int z = startZ;
        for (int y = 0; y <= 1; ++y) {
            while (x <= endX) {
                while (z <= endZ) {
                    Block block = this.spigot.getRelative(x, y, z);
                    Material type = block.getType();
                    if (LegacyUtil.isWoodStairs(type)) {
                        if (y == 0 && !LegacyUtil.areStairsInverted(block)) {
                            return block;
                        }
                        ++z;
                        continue;
                    }
                    return this.spigot.getRelative(x, y, z);
                }
                z = startZ;
                ++x;
            }
            z = startZ;
            x = startX;
        }
        this.bounds = new BoundingBox(this.spigot.getX() + startX, this.spigot.getY(), this.spigot.getZ() + startZ, this.spigot.getX() + endX, this.spigot.getY() + 1, this.spigot.getZ() + endZ);
        return null;
    }

    public Block checkLBarrel() {
        int endZ;
        int endX;
        int startZ;
        int startX;
        int direction = BarrelBody.getDirection(this.spigot);
        if (direction == 0) {
            return this.spigot;
        }
        if (direction == 1) {
            startX = 1;
            startZ = -1;
        } else if (direction == 2) {
            startX = -4;
            startZ = -1;
        } else if (direction == 3) {
            startX = -1;
            startZ = 1;
        } else {
            startX = -1;
            startZ = -4;
        }
        if (direction == 1 || direction == 2) {
            endX = startX + 3;
            endZ = startZ + 2;
        } else {
            endX = startX + 2;
            endZ = startZ + 3;
        }
        int x = startX;
        int z = startZ;
        for (int y = 0; y <= 2; ++y) {
            while (x <= endX) {
                while (z <= endZ) {
                    Block block = this.spigot.getRelative(x, y, z);
                    Material type = block.getType();
                    if (direction == 1 || direction == 2) {
                        if (y == 1 && z == 0) {
                            ++z;
                            continue;
                        }
                    } else if (y == 1 && x == 0) {
                        ++z;
                        continue;
                    }
                    if (LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) {
                        ++z;
                        continue;
                    }
                    return block;
                }
                z = startZ;
                ++x;
            }
            z = startZ;
            x = startX;
        }
        this.bounds = new BoundingBox(this.spigot.getX() + startX, this.spigot.getY(), this.spigot.getZ() + startZ, this.spigot.getX() + endX, this.spigot.getY() + 2, this.spigot.getZ() + endZ);
        return null;
    }

    public void save(ConfigurationSection config, String prefix) {
        if (this.signoffset != 0) {
            config.set(prefix + ".sign", (Object)this.signoffset);
        }
        config.set(prefix + ".bounds", (Object)this.bounds.serialize());
    }
}

