/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.integration.universalScheduler.scheduling.tasks.MyScheduledTask;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BSealer
implements InventoryHolder {
    public static final NamespacedKey TAG_KEY = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "SealingTable");
    public static boolean recipeRegistered = false;
    public static boolean inventoryHolderWorking = true;
    private final Inventory inventory;
    private final Player player;
    private final short[] slotTime = new short[9];
    private ItemStack[] contents = null;
    private MyScheduledTask task;

    public BSealer(Player player) {
        this.player = player;
        if (inventoryHolderWorking) {
            Inventory inv = BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, InventoryType.DISPENSER, BreweryPlugin.getInstance().languageReader.get("Etc_SealingTable", new String[0]));
            if (inv.getHolder() == this) {
                this.inventory = inv;
                return;
            }
            inventoryHolderWorking = false;
        }
        this.inventory = BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 9, BreweryPlugin.getInstance().languageReader.get("Etc_SealingTable", new String[0]));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void clickInv() {
        this.contents = null;
        if (this.task == null) {
            this.task = BreweryPlugin.getScheduler().runTaskTimer((Plugin)BreweryPlugin.getInstance(), this::itemChecking, 1L, 1L);
        }
    }

    public void closeInv() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        for (ItemStack item : this.contents = this.inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            this.player.getWorld().dropItemNaturally(this.player.getLocation(), item);
        }
        this.contents = null;
        this.inventory.clear();
    }

    private void itemChecking() {
        if (this.contents == null) {
            this.contents = this.inventory.getContents();
            for (int i = 0; i < this.slotTime.length; ++i) {
                if (this.contents[i] == null || this.contents[i].getType() != Material.POTION) {
                    this.slotTime[i] = -1;
                    continue;
                }
                if (this.slotTime[i] >= 0) continue;
                this.slotTime[i] = 0;
            }
        }
        boolean playerValid = this.player.isValid() && !this.player.isDead();
        for (int i = 0; i < this.slotTime.length; ++i) {
            if (this.slotTime[i] > 20) {
                this.slotTime[i] = -1;
                Brew brew = Brew.get(this.contents[i]);
                if (brew == null || brew.isStripped()) continue;
                brew.seal(this.contents[i]);
                if (!playerValid || !BreweryPlugin.use1_9) continue;
                this.player.playSound(this.player.getLocation(), Sound.ITEM_BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.5f + (float)(Math.random() * 0.2));
                continue;
            }
            if (this.slotTime[i] < 0) continue;
            int n = i;
            this.slotTime[n] = (short)(this.slotTime[n] + 1);
        }
    }

    public static boolean isBSealer(Block block) {
        Container smoker;
        if (BreweryPlugin.use1_14 && block.getType() == Material.SMOKER && (smoker = (Container)block.getState()).getCustomName() != null) {
            if (smoker.getCustomName().equals("\u00a7e" + BreweryPlugin.getInstance().languageReader.get("Etc_SealingTable", new String[0]))) {
                return true;
            }
            return smoker.getPersistentDataContainer().has(TAG_KEY, PersistentDataType.BYTE);
        }
        return false;
    }

    public static void blockPlace(ItemStack item, Block block) {
        if (item.getType() == Material.SMOKER && item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            assert (itemMeta != null);
            if (itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals("\u00a7e" + BreweryPlugin.getInstance().languageReader.get("Etc_SealingTable", new String[0])) || itemMeta.getPersistentDataContainer().has(TAG_KEY, PersistentDataType.BYTE)) {
                Container smoker = (Container)block.getState();
                Directional dir = (Directional)smoker.getBlockData();
                dir.setFacing(dir.getFacing().getOppositeFace());
                smoker.setBlockData((BlockData)dir);
                smoker.getPersistentDataContainer().set(TAG_KEY, PersistentDataType.BYTE, (Object)1);
                smoker.update();
            }
        }
    }

    public static void registerRecipe() {
        recipeRegistered = true;
        ItemStack sealingTableItem = new ItemStack(Material.SMOKER);
        ItemMeta meta = BreweryPlugin.getInstance().getServer().getItemFactory().getItemMeta(Material.SMOKER);
        if (meta == null) {
            return;
        }
        meta.setDisplayName("\u00a7e" + BreweryPlugin.getInstance().languageReader.get("Etc_SealingTable", new String[0]));
        meta.getPersistentDataContainer().set(TAG_KEY, PersistentDataType.BYTE, (Object)1);
        sealingTableItem.setItemMeta(meta);
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "SealingTable"), sealingTableItem);
        recipe.shape(new String[]{"bb ", "ww ", "ww "});
        recipe.setIngredient('b', Material.GLASS_BOTTLE);
        recipe.setIngredient('w', (RecipeChoice)new RecipeChoice.MaterialChoice(Tag.PLANKS));
        BreweryPlugin.getInstance().getServer().addRecipe((Recipe)recipe);
    }

    public static void unregisterRecipe() {
        recipeRegistered = false;
        Iterator recipeIterator = BreweryPlugin.getInstance().getServer().recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe next = (Recipe)recipeIterator.next();
            if (!(next instanceof ShapedRecipe) || !((ShapedRecipe)next).getKey().equals((Object)TAG_KEY)) continue;
            recipeIterator.remove();
            return;
        }
    }
}

