/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.brew.BrewModifyEvent;
import com.dre.brewery.lore.Base91EncoderStream;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.recipe.RecipeItem;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;

public class BIngredients {
    private static int lastId = 0;
    private int id;
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private int cookedTime;

    public BIngredients() {
    }

    public BIngredients(List<Ingredient> ingredients, int cookedTime) {
        this.ingredients = ingredients;
        this.cookedTime = cookedTime;
    }

    public BIngredients(List<Ingredient> ingredients, int cookedTime, boolean legacy) {
        this(ingredients, cookedTime);
        if (legacy) {
            this.id = lastId++;
        }
    }

    public void add(ItemStack ingredient) {
        for (Ingredient existing : this.ingredients) {
            if (!existing.matches(ingredient)) continue;
            existing.setAmount(existing.getAmount() + 1);
            return;
        }
        Ingredient ing = RecipeItem.getMatchingRecipeItem(ingredient, true).toIngredient(ingredient);
        ing.setAmount(1);
        this.ingredients.add(ing);
    }

    public void add(ItemStack ingredient, RecipeItem rItem) {
        Ingredient ingredientItem = rItem.toIngredient(ingredient);
        for (Ingredient existing : this.ingredients) {
            if (!existing.isSimilar(ingredientItem)) continue;
            existing.setAmount(existing.getAmount() + 1);
            return;
        }
        ingredientItem.setAmount(1);
        this.ingredients.add(ingredientItem);
    }

    public ItemStack cook(int state, String brewer) {
        Brew brew;
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        assert (potionMeta != null);
        this.cookedTime = state;
        String cookedName = null;
        BRecipe cookRecipe = this.getCookRecipe();
        if (cookRecipe != null) {
            int quality = (int)Math.round((double)(this.getIngredientQuality(cookRecipe) + this.getCookingQuality(cookRecipe, false)) / 2.0);
            int alc = Math.round((float)cookRecipe.getAlcohol() * ((float)quality / 10.0f));
            BreweryPlugin.getInstance().debugLog("cooked potion has Quality: " + quality + ", Alc: " + alc);
            brew = new Brew(quality, alc, cookRecipe, this);
            BrewLore lore = new BrewLore(brew, potionMeta);
            lore.updateQualityStars(false);
            lore.updateCustomLore();
            lore.updateAlc(false);
            lore.updateBrewer(brewer);
            lore.addOrReplaceEffects(brew.getEffects(), brew.getQuality());
            lore.write();
            cookedName = cookRecipe.getName(quality);
            cookRecipe.getColor().colorBrew(potionMeta, potion, false);
            brew.updateCustomModelData((ItemMeta)potionMeta);
            if (cookRecipe.hasGlint()) {
                potionMeta.addEnchant(Enchantment.LUCK, 1, true);
                potionMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        } else {
            brew = new Brew(this);
            if (state <= 0) {
                cookedName = BreweryPlugin.getInstance().languageReader.get("Brew_ThickBrew", new String[0]);
                PotionColor.BLUE.colorBrew(potionMeta, potion, false);
            } else {
                BCauldronRecipe cauldronRecipe = this.getCauldronRecipe();
                if (cauldronRecipe != null) {
                    BreweryPlugin.getInstance().debugLog("Found Cauldron Recipe: " + cauldronRecipe.getName());
                    cookedName = cauldronRecipe.getName();
                    if (cauldronRecipe.getLore() != null) {
                        BrewLore lore = new BrewLore(brew, potionMeta);
                        lore.addCauldronLore(cauldronRecipe.getLore());
                        lore.write();
                    }
                    cauldronRecipe.getColor().colorBrew(potionMeta, potion, true);
                    if (BreweryPlugin.use1_14 && cauldronRecipe.getCmData() != 0) {
                        potionMeta.setCustomModelData(Integer.valueOf(cauldronRecipe.getCmData()));
                    }
                }
            }
        }
        if (cookedName == null) {
            cookedName = BreweryPlugin.getInstance().languageReader.get("Brew_Undefined", new String[0]);
            PotionColor.CYAN.colorBrew(potionMeta, potion, true);
        }
        potionMeta.setDisplayName(BreweryPlugin.getInstance().color("&f" + cookedName));
        brew.touch();
        BrewModifyEvent modifyEvent = new BrewModifyEvent(brew, (ItemMeta)potionMeta, BrewModifyEvent.Type.FILL);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
        if (modifyEvent.isCancelled()) {
            return null;
        }
        brew.save((ItemMeta)potionMeta);
        potion.setItemMeta((ItemMeta)potionMeta);
        BreweryPlugin.getInstance().stats.metricsForCreate(false);
        return potion;
    }

    public int getIngredientsCount() {
        int count = 0;
        for (Ingredient ing : this.ingredients) {
            count += ing.getAmount();
        }
        return count;
    }

    public List<Ingredient> getIngredientList() {
        return this.ingredients;
    }

    public int getCookedTime() {
        return this.cookedTime;
    }

    public BRecipe getBestRecipe(float wood, float time, boolean distilled) {
        float quality = 0.0f;
        BRecipe bestRecipe = null;
        for (BRecipe recipe : BRecipe.getAllRecipes()) {
            int ingredientQuality = this.getIngredientQuality(recipe);
            int cookingQuality = this.getCookingQuality(recipe, distilled);
            if (ingredientQuality <= -1 || cookingQuality <= -1) continue;
            if (recipe.needsToAge() || (double)time > 0.5) {
                int ageQuality = this.getAgeQuality(recipe, time);
                int woodQuality = this.getWoodQuality(recipe, wood);
                BreweryPlugin.getInstance().debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " Wood Quality: " + woodQuality + " age Quality: " + ageQuality + " for " + recipe.getName(5));
                if (!(((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f > quality)) continue;
                quality = ((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f;
                bestRecipe = recipe;
                continue;
            }
            BreweryPlugin.getInstance().debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " for " + recipe.getName(5));
            if (!(((float)ingredientQuality + (float)cookingQuality) / 2.0f > quality)) continue;
            quality = ((float)ingredientQuality + (float)cookingQuality) / 2.0f;
            bestRecipe = recipe;
        }
        if (bestRecipe != null) {
            BreweryPlugin.getInstance().debugLog("best recipe: " + bestRecipe.getName(5) + " has Quality= " + quality);
        }
        return bestRecipe;
    }

    public BRecipe getCookRecipe() {
        BRecipe bestRecipe = this.getBestRecipe(0.0f, 0.0f, false);
        if (bestRecipe != null && bestRecipe.isCookingOnly()) {
            return bestRecipe;
        }
        return null;
    }

    @Nullable
    public BCauldronRecipe getCauldronRecipe() {
        BCauldronRecipe best = null;
        float bestMatch = 0.0f;
        for (BCauldronRecipe recipe : BCauldronRecipe.getAllRecipes()) {
            float match = recipe.getIngredientMatch(this.ingredients);
            if (match >= 10.0f) {
                return recipe;
            }
            if (!(match > bestMatch)) continue;
            best = recipe;
            bestMatch = match;
        }
        return best;
    }

    public BRecipe getDistillRecipe(float wood, float time) {
        BRecipe bestRecipe = this.getBestRecipe(wood, time, true);
        if (bestRecipe != null && bestRecipe.needsDistilling()) {
            return bestRecipe;
        }
        return null;
    }

    public BRecipe getAgeRecipe(float wood, float time, boolean distilled) {
        BRecipe bestRecipe = this.getBestRecipe(wood, time, distilled);
        if (bestRecipe != null && bestRecipe.needsToAge()) {
            return bestRecipe;
        }
        return null;
    }

    public int getIngredientQuality(BRecipe recipe) {
        float quality = 10.0f;
        int badStuff = 0;
        if (recipe.isMissingIngredients(this.ingredients)) {
            return -1;
        }
        for (Ingredient ingredient : this.ingredients) {
            int amountInRecipe = recipe.amountOf(ingredient);
            int count = ingredient.getAmount();
            if (amountInRecipe == 0) {
                if (count > this.getIngredientsCount() / 2) {
                    return -1;
                }
                if (++badStuff < this.ingredients.size()) {
                    quality = (float)((double)quality - (double)count * ((double)recipe.getDifficulty() / 2.0));
                    continue;
                }
                return -1;
            }
            quality = (float)((double)quality - (double)((float)Math.abs(count - amountInRecipe) / (float)recipe.allowedCountDiff(amountInRecipe)) * 10.0);
        }
        if (quality >= 0.0f) {
            return Math.round(quality);
        }
        return -1;
    }

    public int getCookingQuality(BRecipe recipe, boolean distilled) {
        if (!recipe.needsDistilling() == distilled) {
            return -1;
        }
        int quality = 10 - (int)Math.round((double)((float)Math.abs(this.cookedTime - recipe.getCookingTime()) / (float)recipe.allowedTimeDiff(recipe.getCookingTime())) * 10.0);
        if (quality >= 0) {
            if (this.cookedTime < 1) {
                return 0;
            }
            return quality;
        }
        return -1;
    }

    public int getDistillQuality(BRecipe recipe, byte distillRuns) {
        if (recipe.needsDistilling() != distillRuns > 0) {
            return 0;
        }
        return 10 - Math.abs(recipe.getDistillRuns() - distillRuns);
    }

    public int getWoodQuality(BRecipe recipe, float wood) {
        if (recipe.getWood() == 0) {
            return 10;
        }
        int quality = 10 - Math.round(recipe.getWoodDiff(wood) * (float)recipe.getDifficulty());
        return Math.max(quality, 0);
    }

    public int getAgeQuality(BRecipe recipe, float time) {
        int quality = 10 - Math.round(Math.abs(time - recipe.getAge()) * ((float)recipe.getDifficulty() / 2.0f));
        return Math.max(quality, 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BIngredients)) {
            return false;
        }
        BIngredients other = (BIngredients)obj;
        return this.cookedTime == other.cookedTime && this.ingredients.equals(other.ingredients);
    }

    public BIngredients copy() {
        BIngredients copy = new BIngredients();
        copy.ingredients.addAll(this.ingredients);
        copy.cookedTime = this.cookedTime;
        return copy;
    }

    public String toString() {
        return "BIngredients{cookedTime=" + this.cookedTime + ", total ingredients: " + this.getIngredientsCount() + "}";
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.cookedTime);
        out.writeByte(this.ingredients.size());
        for (Ingredient ing : this.ingredients) {
            ing.saveTo(out);
            out.writeShort(Math.min(ing.getAmount(), Short.MAX_VALUE));
        }
    }

    public static BIngredients load(DataInputStream in, short dataVersion) throws IOException {
        byte size;
        int cookedTime = in.readInt();
        ArrayList<Ingredient> ing = new ArrayList<Ingredient>(size);
        for (size = in.readByte(); size > 0; size = (byte)(size - 1)) {
            ItemLoader itemLoader = new ItemLoader(dataVersion, in, in.readUTF());
            if (!BreweryPlugin.getInstance().ingredientLoaders.containsKey(itemLoader.getSaveID())) {
                BreweryPlugin.getInstance().errorLog("Ingredient Loader not found: " + itemLoader.getSaveID());
                break;
            }
            Ingredient loaded = BreweryPlugin.getInstance().ingredientLoaders.get(itemLoader.getSaveID()).apply(itemLoader);
            short amount = in.readShort();
            if (loaded == null) continue;
            loaded.setAmount(amount);
            ing.add(loaded);
        }
        return new BIngredients(ing, cookedTime);
    }

    public int saveLegacy(ConfigurationSection config) {
        String path = "Ingredients." + this.id;
        if (this.cookedTime != 0) {
            config.set(path + ".cookedTime", (Object)this.cookedTime);
        }
        config.set(path + ".mats", (Object)this.serializeIngredients());
        return this.id;
    }

    public String serializeIngredients() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new Base91EncoderStream(byteStream));){
            out.writeByte(1);
            this.save(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return byteStream.toString();
    }
}

