/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.integration.universalScheduler.UniversalRunnable;
import com.dre.brewery.integration.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.dre.brewery.lore.BrewLore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class BDistiller {
    private static final int DISTILLTIME = 400;
    private static Map<Block, BDistiller> trackedDistillers = new ConcurrentHashMap<Block, BDistiller>();
    private MyScheduledTask task;
    private int runTime = -1;
    private int brewTime = -1;
    private final Block standBlock;
    private final int fuel;

    public BDistiller(Block standBlock, int fuel) {
        this.standBlock = standBlock;
        this.fuel = fuel;
    }

    public void cancelDistill() {
        this.task.cancel();
    }

    public void start() {
        this.task = new DistillRunnable().runTaskTimer((Plugin)BreweryPlugin.getInstance(), 2L, 1L);
    }

    public static void distillerClick(InventoryClickEvent event) {
        BrewerInventory standInv = (BrewerInventory)event.getInventory();
        Block standBlock = standInv.getHolder().getBlock();
        BDistiller distiller = trackedDistillers.get(standBlock);
        if (distiller != null) {
            distiller.cancelDistill();
            standInv.getHolder().setBrewingTime(0);
            standInv.getHolder().update();
        }
        int fuel = standInv.getHolder().getFuelLevel();
        distiller = new BDistiller(standBlock, fuel);
        trackedDistillers.put(standBlock, distiller);
        distiller.start();
    }

    public static boolean isTrackingDistiller(Block block) {
        return trackedDistillers.containsKey(block);
    }

    public static Brew[] getDistillContents(BrewerInventory inv) {
        Brew[] contents = new Brew[3];
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null) continue;
            contents[slot] = Brew.get(item);
        }
        return contents;
    }

    public static void checkContents(BrewerInventory inv, Brew[] contents) {
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack item;
            if (contents[slot] == null || Brew.isBrew(item = inv.getItem(slot))) continue;
            contents[slot] = null;
        }
    }

    public static byte hasBrew(BrewerInventory brewer, Brew[] contents) {
        ItemStack item = brewer.getItem(3);
        boolean glowstone = item != null && Material.GLOWSTONE_DUST == item.getType();
        byte customFound = 0;
        for (Brew brew : contents) {
            if (brew == null) continue;
            if (!glowstone) {
                return 1;
            }
            if (brew.canDistill()) {
                return 2;
            }
            customFound = 1;
        }
        return customFound;
    }

    public static boolean runDistill(BrewerInventory inv, Brew[] contents) {
        boolean custom = false;
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            if (contents[slot].canDistill()) {
                custom = true;
                continue;
            }
            contents[slot] = null;
        }
        if (custom) {
            Brew.distillAll(inv, contents);
            return true;
        }
        return false;
    }

    public static int getLongestDistillTime(Brew[] contents) {
        int bestTime = 0;
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            int time = contents[slot].getDistillTimeNextRun();
            if (time == 0) {
                time = 800;
            }
            if (time <= bestTime) continue;
            bestTime = time;
        }
        if (bestTime > 0) {
            return bestTime;
        }
        return 800;
    }

    public static void showAlc(BrewerInventory inv, Brew[] contents) {
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            ItemStack item = inv.getItem(slot);
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            BrewLore brewLore = new BrewLore(contents[slot], meta);
            brewLore.updateAlc(true);
            brewLore.write();
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public class DistillRunnable
    extends UniversalRunnable {
        private Brew[] contents = null;

        @Override
        public void run() {
            BreweryPlugin.getScheduler().runTask(BDistiller.this.standBlock.getLocation(), () -> {
                BlockState now = BDistiller.this.standBlock.getState();
                if (now instanceof BrewingStand) {
                    BrewingStand stand = (BrewingStand)now;
                    if (BDistiller.this.brewTime == -1 && !this.prepareForDistillables(stand)) {
                        return;
                    }
                    --BDistiller.this.brewTime;
                    stand.setBrewingTime((int)((float)BDistiller.this.brewTime / ((float)BDistiller.this.runTime / 400.0f)) + 1);
                    if (BDistiller.this.brewTime <= 1) {
                        this.contents = BDistiller.getDistillContents(stand.getInventory());
                        stand.setBrewingTime(0);
                        stand.update();
                        if (!BDistiller.runDistill(stand.getInventory(), this.contents)) {
                            this.cancel();
                            trackedDistillers.remove(BDistiller.this.standBlock);
                            BreweryPlugin.getInstance().debugLog("All done distilling");
                        } else {
                            BDistiller.this.brewTime = -1;
                            BreweryPlugin.getInstance().debugLog("Can distill more! Continuing.");
                        }
                    } else {
                        stand.update();
                    }
                } else {
                    this.cancel();
                    trackedDistillers.remove(BDistiller.this.standBlock);
                    BreweryPlugin.getInstance().debugLog("The block was replaced; not a brewing stand.");
                }
            });
        }

        private boolean prepareForDistillables(BrewingStand stand) {
            BrewerInventory inventory = stand.getInventory();
            if (this.contents == null) {
                this.contents = BDistiller.getDistillContents(inventory);
            } else {
                BDistiller.checkContents(inventory, this.contents);
            }
            switch (BDistiller.hasBrew(inventory, this.contents)) {
                case 1: {
                    if (stand.getBrewingTime() > 0) {
                        if (BreweryPlugin.use1_11) {
                            stand.setBrewingTime(Short.MAX_VALUE);
                        } else {
                            stand.setBrewingTime(65534);
                        }
                        stand.setFuelLevel(BDistiller.this.fuel);
                        stand.update();
                    }
                }
                case 0: {
                    this.cancel();
                    trackedDistillers.remove(BDistiller.this.standBlock);
                    BDistiller.showAlc(inventory, this.contents);
                    BreweryPlugin.getInstance().debugLog("nothing to distill");
                    return false;
                }
            }
            BDistiller.this.brewTime = BDistiller.this.runTime = BDistiller.getLongestDistillTime(this.contents);
            BreweryPlugin.getInstance().debugLog("using brewtime: " + BDistiller.this.runTime);
            return true;
        }
    }
}

