/*
 * Decompiled with CFR 0.152.
 */
package eu.okaeri.configs.migrate.builtin.action;

import eu.okaeri.configs.OkaeriConfig;
import eu.okaeri.configs.migrate.ConfigMigration;
import eu.okaeri.configs.migrate.view.RawConfigView;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class SimpleMoveMigration
implements ConfigMigration {
    private final String fromKey;
    private final String toKey;
    private Function<Object, Object> updateFunction;

    @Override
    public boolean migrate(@NonNull OkaeriConfig config, @NonNull RawConfigView view) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (view == null) {
            throw new NullPointerException("view is marked non-null but is null");
        }
        if (!view.exists(this.fromKey)) {
            return false;
        }
        Object targetValue = view.remove(this.fromKey);
        if (this.updateFunction == null) {
            view.set(this.toKey, targetValue);
            return true;
        }
        Object updatedValue = this.updateFunction.apply(targetValue);
        view.set(this.toKey, updatedValue);
        return true;
    }

    @Generated
    public String toString() {
        return "SimpleMoveMigration(fromKey=" + this.fromKey + ", toKey=" + this.toKey + ", updateFunction=" + this.updateFunction + ")";
    }

    @Generated
    public SimpleMoveMigration(String fromKey, String toKey, Function<Object, Object> updateFunction) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.updateFunction = updateFunction;
    }

    @Generated
    public SimpleMoveMigration(String fromKey, String toKey) {
        this.fromKey = fromKey;
        this.toKey = toKey;
    }
}

