/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.util;

import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Ldev/jsinco/recipes/util/Logger;", "", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "prefix", "", "s", "m", "log", "", "message", "logErr", "throwable", "", "logDev", "Recipes"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();

    private Logger() {
    }

    private final java.util.logging.Logger logger() {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("BreweryRecipes");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        return logger;
    }

    @NotNull
    public final String prefix(@NotNull String s, @NotNull String m) {
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(m, "m");
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        String string = caller.getClassName();
        Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
        String className = StringsKt.substringAfterLast$default(string, '.', null, 2, null);
        return "[BreweryRecipes " + s + " - " + className + ":" + caller.getLineNumber() + "] " + m;
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.logger().log(Level.INFO, this.prefix("Info", message));
    }

    public final void logErr(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.logger().log(Level.SEVERE, this.prefix("Error", message));
    }

    public final void logErr(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        java.util.logging.Logger logger = this.logger();
        String string = throwable.getMessage();
        if (string == null) {
            string = "";
        }
        logger.log(Level.SEVERE, this.prefix("Error", string), throwable);
    }

    public final void logDev(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.logger().log(Level.WARNING, this.prefix("Debug", message));
    }
}

