/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.gui;

import dev.jsinco.recipes.Recipes;
import dev.jsinco.recipes.configuration.ConfigItemCollection;
import dev.jsinco.recipes.configuration.gui.GuiBorderType;
import dev.jsinco.recipes.configuration.gui.GuiOverride;
import dev.jsinco.recipes.gui.GuiItem;
import dev.jsinco.recipes.util.GUIUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u0006\u0010\u0018\u001a\u00020\u0015J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\bJ\r\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020 J\r\u0010!\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/jsinco/recipes/gui/RecipesGui;", "Lorg/bukkit/inventory/InventoryHolder;", "player", "Lorg/bukkit/entity/Player;", "recipes", "", "Ldev/jsinco/recipes/gui/GuiItem;", "size", "", "<init>", "(Lorg/bukkit/entity/Player;Ljava/util/List;I)V", "inventory", "Lorg/bukkit/inventory/Inventory;", "Lorg/jetbrains/annotations/NotNull;", "renderedGuiItems", "", "recipesSlots", "pageRecipeCapacity", "maxPages", "page", "nextPage", "", "previousPage", "findRecipeSlots", "render", "renderItem", "guiItem", "position", "open", "Lorg/bukkit/inventory/InventoryView;", "Lorg/jspecify/annotations/Nullable;", "calculateGuiName", "Lnet/kyori/adventure/text/Component;", "getInventory", "Recipes"})
public final class RecipesGui
implements InventoryHolder {
    @NotNull
    private final Player player;
    @NotNull
    private final List<GuiItem> recipes;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Set<GuiItem> renderedGuiItems;
    @NotNull
    private final List<Integer> recipesSlots;
    private final int pageRecipeCapacity;
    private final int maxPages;
    private int page;

    public RecipesGui(@NotNull Player player, @NotNull List<GuiItem> recipes, int size) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(recipes, "recipes");
        this.player = player;
        this.recipes = recipes;
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)this.calculateGuiName());
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
        this.renderedGuiItems = new LinkedHashSet();
        this.recipesSlots = this.findRecipeSlots();
        this.pageRecipeCapacity = this.recipesSlots.size();
        this.maxPages = Math.ceilDiv(this.recipes.size(), this.pageRecipeCapacity);
    }

    public /* synthetic */ RecipesGui(Player player, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 54;
        }
        this(player, list, n);
    }

    public final void nextPage() {
        this.page = RangesKt.coerceAtMost(this.page + 1, this.maxPages - 1);
        this.render();
    }

    public final void previousPage() {
        this.page = RangesKt.coerceAtLeast(this.page - 1, 0);
        this.render();
    }

    @NotNull
    public final List<Integer> findRecipeSlots() {
        List output = CollectionsKt.toMutableList(RangesKt.until(0, 54));
        for (Map.Entry<GuiBorderType, ConfigItemCollection> borderEntry : Recipes.Companion.getGuiConfig().getBorders().entrySet()) {
            output.removeAll((Collection)ArraysKt.toList(borderEntry.getKey().getPositions()));
        }
        for (GuiOverride guiOverride : Recipes.Companion.getGuiConfig().getOverrides()) {
            Iterator<Integer> iterator2 = GUIUtil.INSTANCE.getValidSlots(guiOverride.getPos()).iterator();
            while (iterator2.hasNext()) {
                int slot = ((Number)iterator2.next()).intValue();
                output.remove((Object)slot);
            }
        }
        return CollectionsKt.toList(output);
    }

    public final void render() {
        Object borderType;
        this.inventory.clear();
        for (Map.Entry<GuiBorderType, ConfigItemCollection> borderEntry : Recipes.Companion.getGuiConfig().getBorders().entrySet()) {
            borderType = borderEntry.getKey();
            ConfigItemCollection palette = borderEntry.getValue();
            int n = ((GuiBorderType)((Object)borderType)).getPositions().length;
            for (int i = 0; i < n; ++i) {
                int pos = ((GuiBorderType)((Object)borderType)).getPositions()[i];
                ItemStack item = palette.getContent().get(i % palette.getContent().size()).generateItem();
                this.renderItem(new GuiItem(item, GuiItem.Type.NO_ACTION), pos);
            }
        }
        for (GuiOverride override : Recipes.Companion.getGuiConfig().getOverrides()) {
            if (override.getType() == GuiItem.Type.PREVIOUS_PAGE && this.page == 0 || override.getType() == GuiItem.Type.NEXT_PAGE && this.page + 1 >= this.maxPages) continue;
            borderType = GUIUtil.INSTANCE.getValidSlots(override.getPos()).iterator();
            while (borderType.hasNext()) {
                int slot = ((Number)borderType.next()).intValue();
                this.renderItem(new GuiItem(override.getItem().generateItem(), override.getType()), slot);
            }
        }
        int startPageContentIndex = this.page * this.pageRecipeCapacity;
        int recipesToRead = Math.min(this.pageRecipeCapacity, this.recipes.size() - startPageContentIndex);
        for (int i = 0; i < recipesToRead; ++i) {
            this.renderItem(this.recipes.get(i + startPageContentIndex), ((Number)this.recipesSlots.get(i)).intValue());
        }
    }

    public final void renderItem(@NotNull GuiItem guiItem, int position) {
        Intrinsics.checkNotNullParameter(guiItem, "guiItem");
        ItemStack item = guiItem.item();
        if (!this.renderedGuiItems.contains(guiItem)) {
            this.renderedGuiItems.add(guiItem);
        }
        this.inventory.setItem(position, item);
    }

    @Nullable
    public final InventoryView open() {
        return this.open(this.player);
    }

    @Nullable
    public final InventoryView open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return player.openInventory(this.inventory);
    }

    @NotNull
    public final Component calculateGuiName() {
        Component component;
        if (this.player.hasPermission("recipes.override.view")) {
            TranslatableComponent translatableComponent = Component.translatable((String)"recipes.display.gui.name.admin");
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
            component = (Component)translatableComponent;
        } else {
            TranslatableComponent translatableComponent = Component.translatable((String)"recipes.display.gui.name");
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
            component = (Component)translatableComponent;
        }
        return component;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

