/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.data.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.core.flaws.Flaw;
import dev.jsinco.recipes.data.StorageImpl;
import dev.jsinco.recipes.data.StorageType;
import dev.jsinco.recipes.data.serdes.FlawSerdes;
import dev.jsinco.recipes.data.serdes.Serdes;
import dev.jsinco.recipes.util.Logger;
import dev.jsinco.recipes.util.UuidUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001b\u0018\u00010\u001a0\u0010H\u0016J2\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001d0\u0010\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u001d0 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/jsinco/recipes/data/storage/SQLiteStorageImpl;", "Ldev/jsinco/recipes/data/StorageImpl;", "dataFolder", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "getType", "Ldev/jsinco/recipes/data/StorageType;", "setupDataSource", "createTables", "", "insertOrUpdateRecipeView", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "playerUuid", "Ljava/util/UUID;", "recipeView", "Ldev/jsinco/recipes/core/RecipeView;", "removeRecipeView", "recipeKey", "", "selectAllRecipeViews", "", "", "runStatement", "T", "statement", "supplier", "Lkotlin/Function1;", "Ljava/sql/PreparedStatement;", "Recipes"})
public final class SQLiteStorageImpl
implements StorageImpl {
    @NotNull
    private final File dataFolder;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final HikariDataSource dataSource;

    public SQLiteStorageImpl(@NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.dataFolder = dataFolder;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "newSingleThreadScheduledExecutor(...)");
        this.executor = scheduledExecutorService;
        this.dataSource = this.setupDataSource();
    }

    @Override
    @NotNull
    public StorageType getType() {
        return StorageType.SQLite;
    }

    private final HikariDataSource setupDataSource() {
        HikariConfig config = new HikariConfig();
        File databaseFile = new File(this.dataFolder, "recipes.sqlite");
        String jdbcUrl = "jdbc:sqlite:" + databaseFile.getAbsolutePath();
        config.setJdbcUrl(jdbcUrl);
        config.setPoolName("SQLitePool");
        config.setConnectionTestQuery("SELECT 1");
        config.setMaximumPoolSize(1);
        config.setMinimumIdle(1);
        config.setMaxLifetime(300000L);
        config.setInitializationFailTimeout(-1L);
        return new HikariDataSource(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTables() {
        String sql = "CREATE TABLE IF NOT EXISTS recipe_view (\n  player_uuid BINARY(16) NOT NULL,\n  recipe_key TEXT NOT NULL,\n  recipe_flaws JSON NOT NULL,\n  inverted_reveals JSON NOT NULL,\n  PRIMARY KEY (player_uuid, recipe_key)\n);";
        try {
            AutoCloseable autoCloseable = this.dataSource.getConnection();
            Throwable throwable = null;
            try {
                boolean bl;
                Connection conn = (Connection)autoCloseable;
                boolean bl2 = false;
                AutoCloseable autoCloseable2 = conn.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement stmt = (Statement)autoCloseable2;
                    boolean bl3 = false;
                    bl = stmt.execute(sql);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                }
                boolean bl4 = bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
        catch (SQLException e) {
            Logger.INSTANCE.logErr(e);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> insertOrUpdateRecipeView(@NotNull UUID playerUuid, @NotNull RecipeView recipeView) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(recipeView, "recipeView");
        return this.runStatement("\n                INSERT OR REPLACE INTO recipe_view\n                  VALUES(?,?,?,?);\n            ", arg_0 -> SQLiteStorageImpl.insertOrUpdateRecipeView$lambda$0(playerUuid, recipeView, arg_0));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> removeRecipeView(@NotNull UUID playerUuid, @NotNull String recipeKey) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(recipeKey, "recipeKey");
        return this.runStatement("\n                DELETE FROM recipe_view\n                    WHERE player_uuid = ? AND recipe_key = ?;\n            ", arg_0 -> SQLiteStorageImpl.removeRecipeView$lambda$0(playerUuid, recipeKey, arg_0));
    }

    @Override
    @NotNull
    public CompletableFuture<Map<UUID, List<RecipeView>>> selectAllRecipeViews() {
        return this.runStatement("SELECT * FROM recipe_view;", SQLiteStorageImpl::selectAllRecipeViews$lambda$0);
    }

    private final <T> CompletableFuture<T> runStatement(String statement, Function1<? super PreparedStatement, ? extends T> supplier) {
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> SQLiteStorageImpl.runStatement$lambda$0(this, statement, supplier), this.executor).handleAsync((arg_0, arg_1) -> SQLiteStorageImpl.runStatement$lambda$2(SQLiteStorageImpl::runStatement$lambda$1, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(completionStage, "handleAsync(...)");
        return completionStage;
    }

    private static final Void insertOrUpdateRecipeView$lambda$0(UUID $playerUuid, RecipeView $recipeView, PreparedStatement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBytes(1, UuidUtil.INSTANCE.toBytes($playerUuid));
        it.setString(2, $recipeView.getRecipeIdentifier());
        it.setString(3, Serdes.INSTANCE.serializeCollection((Collection)$recipeView.getFlaws(), FlawSerdes.INSTANCE::serializeFlaw).toString());
        it.setString(4, Serdes.INSTANCE.serializeCollection((Collection)$recipeView.getInvertedReveals(), SQLiteStorageImpl::insertOrUpdateRecipeView$lambda$0$0).toString());
        it.execute();
        return null;
    }

    private static final JsonElement insertOrUpdateRecipeView$lambda$0$0(Set ints) {
        Intrinsics.checkNotNullParameter(ints, "ints");
        return (JsonElement)Serdes.INSTANCE.serializeCollection(ints, SQLiteStorageImpl::insertOrUpdateRecipeView$lambda$0$0$0);
    }

    private static final JsonElement insertOrUpdateRecipeView$lambda$0$0$0(Integer number) {
        Intrinsics.checkNotNullParameter(number, "number");
        return (JsonElement)new JsonPrimitive((Number)number);
    }

    private static final Void removeRecipeView$lambda$0(UUID $playerUuid, String $recipeKey, PreparedStatement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setBytes(1, UuidUtil.INSTANCE.toBytes($playerUuid));
        it.setString(2, $recipeKey);
        it.execute();
        return null;
    }

    private static final Map selectAllRecipeViews$lambda$0(PreparedStatement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ResultSet result = it.executeQuery();
        Map output = new LinkedHashMap();
        while (result.next()) {
            List recipeViews;
            byte[] byArray = result.getBytes("player_uuid");
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            Intrinsics.checkNotNullExpressionValue(output.computeIfAbsent(UuidUtil.INSTANCE.asUuid(byArray), arg_0 -> SQLiteStorageImpl.selectAllRecipeViews$lambda$0$1(SQLiteStorageImpl::selectAllRecipeViews$lambda$0$0, arg_0)), "computeIfAbsent(...)");
            String string = result.getString("recipe_key");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            JsonArray jsonArray = JsonParser.parseString((String)result.getString("recipe_flaws")).getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
            List<Flaw> list = Serdes.INSTANCE.deserializeList(jsonArray, FlawSerdes.INSTANCE::deserializeFlaw);
            JsonArray jsonArray2 = JsonParser.parseString((String)result.getString("inverted_reveals")).getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue(jsonArray2, "getAsJsonArray(...)");
            recipeViews.add(new RecipeView(string, list, Serdes.INSTANCE.deserializeList(jsonArray2, SQLiteStorageImpl::selectAllRecipeViews$lambda$0$2)));
        }
        return output;
    }

    private static final List selectAllRecipeViews$lambda$0$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List selectAllRecipeViews$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Set selectAllRecipeViews$lambda$0$2(JsonElement jsonArray) {
        Intrinsics.checkNotNullParameter(jsonArray, "jsonArray");
        JsonArray jsonArray2 = jsonArray.getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue(jsonArray2, "getAsJsonArray(...)");
        return Serdes.INSTANCE.deserializeSet(jsonArray2, SQLiteStorageImpl::selectAllRecipeViews$lambda$0$2$0);
    }

    private static final Integer selectAllRecipeViews$lambda$0$2$0(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element.getAsInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object runStatement$lambda$0(SQLiteStorageImpl this$0, String $statement, Function1 $supplier) {
        AutoCloseable autoCloseable = this$0.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Object r;
            Connection it = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = it.prepareStatement($statement);
            Throwable throwable2 = null;
            try {
                PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull(preparedStatement);
                r = $supplier.invoke(preparedStatement);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            Object r2 = r;
            return r2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final Object runStatement$lambda$1(Object t, Throwable e) {
        if (e != null) {
            Logger.INSTANCE.logErr(e);
            return null;
        }
        return t;
    }

    private static final Object runStatement$lambda$2(Function2 $tmp0, Object p0, Throwable p1) {
        return $tmp0.invoke(p0, p1);
    }
}

