/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws.drunkentext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0001(B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J;\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0019H\u00d6\u0001J\t\u0010'\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006)"}, d2={"Ldev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement;", "", "pattern", "Lkotlin/text/Regex;", "minimumIntensity", "", "probability", "replacement", "", "faultLevel", "<init>", "(Lkotlin/text/Regex;DDLjava/lang/String;D)V", "getPattern", "()Lkotlin/text/Regex;", "getMinimumIntensity", "()D", "getProbability", "getReplacement", "()Ljava/lang/String;", "getFaultLevel", "replacements", "", "Ldev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement$Replacement;", "text", "seed", "", "startPos", "filter", "Ljava/util/function/Predicate;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "Replacement", "Recipes"})
@SourceDebugExtension(value={"SMAP\nDrunkenTextReplacement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrunkenTextReplacement.kt\ndev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1563#2:45\n1634#2,3:46\n1761#2,3:49\n*S KotlinDebug\n*F\n+ 1 DrunkenTextReplacement.kt\ndev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement\n*L\n22#1:45\n22#1:46,3\n23#1:49,3\n*E\n"})
public final class DrunkenTextReplacement {
    @NotNull
    private final Regex pattern;
    private final double minimumIntensity;
    private final double probability;
    @NotNull
    private final String replacement;
    private final double faultLevel;

    public DrunkenTextReplacement(@NotNull Regex pattern, double minimumIntensity, double probability, @NotNull String replacement, double faultLevel) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        this.pattern = pattern;
        this.minimumIntensity = minimumIntensity;
        this.probability = probability;
        this.replacement = replacement;
        this.faultLevel = faultLevel;
    }

    @NotNull
    public final Regex getPattern() {
        return this.pattern;
    }

    public final double getMinimumIntensity() {
        return this.minimumIntensity;
    }

    public final double getProbability() {
        return this.probability;
    }

    @NotNull
    public final String getReplacement() {
        return this.replacement;
    }

    public final double getFaultLevel() {
        return this.faultLevel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Replacement> replacements(@NotNull String text, int seed, int startPos, @NotNull Predicate<Integer> filter) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(filter, "filter");
        List output = new ArrayList();
        Iterator iterator2 = Regex.findAll$default(this.pattern, text, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            String content;
            block8: {
                void $this$any$iv;
                Iterator $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                MatchResult match = (MatchResult)iterator2.next();
                if (RandomKt.Random(seed + startPos + match.getRange().getStart()).nextDouble() > this.probability) continue;
                content = match.getValue();
                Iterable iterable = RangesKt.until(0, content.length());
                boolean $i$f$map = false;
                void var11_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((int)(it + startPos));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$mapTo$iv$iv = $this$any$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        int it = ((Number)element$iv).intValue();
                        boolean bl3 = false;
                        if (!(!filter.test(it))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            int n = RangesKt.coerceAtLeast(content.length(), this.replacement.length());
            for (int i = 0; i < n; ++i) {
                String string;
                if (content.length() > i - 1) {
                    string = this.replacement.length() <= i ? "" : String.valueOf(this.replacement.charAt(i));
                } else {
                    String string2 = this.replacement.substring(i);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                }
                String posReplacement = string;
                output.add(new Replacement(i + startPos, posReplacement));
            }
        }
        return output;
    }

    @NotNull
    public final Regex component1() {
        return this.pattern;
    }

    public final double component2() {
        return this.minimumIntensity;
    }

    public final double component3() {
        return this.probability;
    }

    @NotNull
    public final String component4() {
        return this.replacement;
    }

    public final double component5() {
        return this.faultLevel;
    }

    @NotNull
    public final DrunkenTextReplacement copy(@NotNull Regex pattern, double minimumIntensity, double probability, @NotNull String replacement, double faultLevel) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        return new DrunkenTextReplacement(pattern, minimumIntensity, probability, replacement, faultLevel);
    }

    public static /* synthetic */ DrunkenTextReplacement copy$default(DrunkenTextReplacement drunkenTextReplacement, Regex regex, double d, double d2, String string, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            regex = drunkenTextReplacement.pattern;
        }
        if ((n & 2) != 0) {
            d = drunkenTextReplacement.minimumIntensity;
        }
        if ((n & 4) != 0) {
            d2 = drunkenTextReplacement.probability;
        }
        if ((n & 8) != 0) {
            string = drunkenTextReplacement.replacement;
        }
        if ((n & 0x10) != 0) {
            d3 = drunkenTextReplacement.faultLevel;
        }
        return drunkenTextReplacement.copy(regex, d, d2, string, d3);
    }

    @NotNull
    public String toString() {
        return "DrunkenTextReplacement(pattern=" + this.pattern + ", minimumIntensity=" + this.minimumIntensity + ", probability=" + this.probability + ", replacement=" + this.replacement + ", faultLevel=" + this.faultLevel + ")";
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = result * 31 + Double.hashCode(this.minimumIntensity);
        result = result * 31 + Double.hashCode(this.probability);
        result = result * 31 + this.replacement.hashCode();
        result = result * 31 + Double.hashCode(this.faultLevel);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrunkenTextReplacement)) {
            return false;
        }
        DrunkenTextReplacement drunkenTextReplacement = (DrunkenTextReplacement)other;
        if (!Intrinsics.areEqual(this.pattern, drunkenTextReplacement.pattern)) {
            return false;
        }
        if (Double.compare(this.minimumIntensity, drunkenTextReplacement.minimumIntensity) != 0) {
            return false;
        }
        if (Double.compare(this.probability, drunkenTextReplacement.probability) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.replacement, drunkenTextReplacement.replacement)) {
            return false;
        }
        return Double.compare(this.faultLevel, drunkenTextReplacement.faultLevel) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ldev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement$Replacement;", "", "pos", "", "replacement", "", "<init>", "(ILjava/lang/String;)V", "getPos", "()I", "getReplacement", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Recipes"})
    public static final class Replacement {
        private final int pos;
        @NotNull
        private final String replacement;

        public Replacement(int pos, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter(replacement, "replacement");
            this.pos = pos;
            this.replacement = replacement;
        }

        public final int getPos() {
            return this.pos;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        public final int component1() {
            return this.pos;
        }

        @NotNull
        public final String component2() {
            return this.replacement;
        }

        @NotNull
        public final Replacement copy(int pos, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter(replacement, "replacement");
            return new Replacement(pos, replacement);
        }

        public static /* synthetic */ Replacement copy$default(Replacement replacement, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = replacement.pos;
            }
            if ((n2 & 2) != 0) {
                string = replacement.replacement;
            }
            return replacement.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "Replacement(pos=" + this.pos + ", replacement=" + this.replacement + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.pos);
            result = result * 31 + this.replacement.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Replacement)) {
                return false;
            }
            Replacement replacement = (Replacement)other;
            if (this.pos != replacement.pos) {
                return false;
            }
            return Intrinsics.areEqual(this.replacement, replacement.replacement);
        }
    }
}

