/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.commands.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.recipes.Recipes;
import dev.jsinco.recipes.core.BreweryRecipe;
import dev.jsinco.recipes.util.TranslationUtil;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Ldev/jsinco/recipes/commands/argument/RecipeArgumentType;", "Lio/papermc/paper/command/brigadier/argument/CustomArgumentType$Converted;", "Ldev/jsinco/recipes/core/BreweryRecipe;", "", "<init>", "()V", "UNKNOWN_VALUE", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "getUNKNOWN_VALUE", "()Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "WORD_ARGUMENT", "Lkotlin/text/Regex;", "getWORD_ARGUMENT", "()Lkotlin/text/Regex;", "convert", "nativeType", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "sanitizeName", "name", "getNativeType", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nRecipeArgumentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeArgumentType.kt\ndev/jsinco/recipes/commands/argument/RecipeArgumentType\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,61:1\n1321#2,2:62\n*S KotlinDebug\n*F\n+ 1 RecipeArgumentType.kt\ndev/jsinco/recipes/commands/argument/RecipeArgumentType\n*L\n46#1:62,2\n*E\n"})
public final class RecipeArgumentType
implements CustomArgumentType.Converted<BreweryRecipe, String> {
    @NotNull
    public static final RecipeArgumentType INSTANCE = new RecipeArgumentType();
    @NotNull
    private static final DynamicCommandExceptionType UNKNOWN_VALUE = new DynamicCommandExceptionType(RecipeArgumentType::UNKNOWN_VALUE$lambda$0);
    @NotNull
    private static final Regex WORD_ARGUMENT = new Regex("[a-zA-Z0-9+\\-_.]+");

    private RecipeArgumentType() {
    }

    @NotNull
    public final DynamicCommandExceptionType getUNKNOWN_VALUE() {
        return UNKNOWN_VALUE;
    }

    @NotNull
    public final Regex getWORD_ARGUMENT() {
        return WORD_ARGUMENT;
    }

    @NotNull
    public BreweryRecipe convert(@NotNull String nativeType) {
        Intrinsics.checkNotNullParameter(nativeType, "nativeType");
        BreweryRecipe breweryRecipe = Recipes.Companion.recipes().get(nativeType);
        if (breweryRecipe == null) {
            CommandSyntaxException commandSyntaxException = UNKNOWN_VALUE.create((Object)nativeType);
            Intrinsics.checkNotNullExpressionValue(commandSyntaxException, "create(...)");
            throw (Throwable)commandSyntaxException;
        }
        return breweryRecipe;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Sequence $this$forEach$iv = SequencesKt.map(SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)Recipes.Companion.recipes().values()), RecipeArgumentType::listSuggestions$lambda$0), arg_0 -> RecipeArgumentType.listSuggestions$lambda$1(builder, arg_0)), (Function1)new Function1<String, String>((Object)this){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return RecipeArgumentType.access$sanitizeName((RecipeArgumentType)this.receiver, p0);
            }
        });
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String p0 = (String)element$iv;
            boolean bl = false;
            builder.suggest(p0);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final String sanitizeName(String name) {
        if (WORD_ARGUMENT.matches(name)) {
            return name;
        }
        return "\"" + name + "\"";
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        StringArgumentType stringArgumentType = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue(stringArgumentType, "string(...)");
        return (ArgumentType)stringArgumentType;
    }

    private static final Message UNKNOWN_VALUE$lambda$0(Object it) {
        MessageComponentSerializer messageComponentSerializer = MessageComponentSerializer.message();
        ComponentLike[] componentLikeArray = new ComponentLike[]{Argument.numeric((String)"argument", (String)it.toString())};
        TranslatableComponent translatableComponent = Component.translatable((String)"recipes.command.invalid.argument", (ComponentLike[])componentLikeArray);
        Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
        return (Message)messageComponentSerializer.serialize(TranslationUtil.INSTANCE.render((Component)translatableComponent));
    }

    private static final String listSuggestions$lambda$0(BreweryRecipe it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getIdentifier();
    }

    private static final boolean listSuggestions$lambda$1(SuggestionsBuilder $builder, String recipeName) {
        Intrinsics.checkNotNullParameter(recipeName, "recipeName");
        String string = $builder.getRemainingLowerCase();
        Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
        return StringsKt.startsWith$default(recipeName, string, false, 2, null);
    }

    public static final /* synthetic */ String access$sanitizeName(RecipeArgumentType $this, String name) {
        return $this.sanitizeName(name);
    }
}

