/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Ldev/jsinco/recipes/util/UuidUtil;", "", "<init>", "()V", "toBytes", "", "uuid", "Ljava/util/UUID;", "asUuid", "byteArray", "Recipes"})
public final class UuidUtil {
    @NotNull
    public static final UuidUtil INSTANCE = new UuidUtil();

    private UuidUtil() {
    }

    @NotNull
    public final byte[] toBytes(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        byte[] byArray = bb.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    @NotNull
    public final UUID asUuid(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }
}

