/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.util;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.recipes.core.BreweryRecipe;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0014\u0010\r\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nH\u0002\u00a8\u0006\u000f"}, d2={"Ldev/jsinco/recipes/util/TBPRecipeConverter;", "", "<init>", "()V", "convert", "Ldev/jsinco/recipes/core/BreweryRecipe;", "recipe", "Ldev/jsinco/brewery/api/recipe/Recipe;", "Lorg/bukkit/inventory/ItemStack;", "mapIngredients", "", "Ldev/jsinco/recipes/core/process/Ingredient;", "", "ingredients", "Ldev/jsinco/brewery/api/ingredient/Ingredient;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nTBPRecipeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TBPRecipeConverter.kt\ndev/jsinco/recipes/util/TBPRecipeConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 TBPRecipeConverter.kt\ndev/jsinco/recipes/util/TBPRecipeConverter\n*L\n15#1:42,2\n*E\n"})
public final class TBPRecipeConverter {
    @NotNull
    public static final TBPRecipeConverter INSTANCE = new TBPRecipeConverter();

    private TBPRecipeConverter() {
    }

    @NotNull
    public final BreweryRecipe convert(@NotNull Recipe<ItemStack> recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        String string = recipe.getRecipeName();
        Intrinsics.checkNotNullExpressionValue(string, "getRecipeName(...)");
        BreweryRecipe.Builder recipeBuilder = new BreweryRecipe.Builder(string);
        List steps = recipe.getSteps();
        Intrinsics.checkNotNull(steps);
        Iterable $this$forEach$iv = steps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BrewingStep it = (BrewingStep)element$iv;
            boolean bl = false;
            BrewingStep brewingStep = it;
            if (brewingStep instanceof BrewingStep.Cook) {
                long l = ((BrewingStep.Cook)it).time().moment();
                String string2 = ((BrewingStep.Cook)it).cauldronType().name();
                Map map = ((BrewingStep.Cook)it).ingredients();
                Intrinsics.checkNotNullExpressionValue(map, "ingredients(...)");
                recipeBuilder.cook(l, string2, INSTANCE.mapIngredients(map));
                continue;
            }
            if (brewingStep instanceof BrewingStep.Distill) {
                recipeBuilder.distill(((BrewingStep.Distill)it).runs());
                continue;
            }
            if (brewingStep instanceof BrewingStep.Age) {
                recipeBuilder.age(((BrewingStep.Age)it).time().moment(), ((BrewingStep.Age)it).barrelType().name());
                continue;
            }
            if (!(brewingStep instanceof BrewingStep.Mix)) continue;
            long l = ((BrewingStep.Mix)it).time().moment();
            Map map = ((BrewingStep.Mix)it).ingredients();
            Intrinsics.checkNotNullExpressionValue(map, "ingredients(...)");
            recipeBuilder.mix(l, "WATER", INSTANCE.mapIngredients(map));
        }
        return recipeBuilder.build();
    }

    private final Map<dev.jsinco.recipes.core.process.Ingredient, Integer> mapIngredients(Map<? extends Ingredient, Integer> ingredients) {
        return MapsKt.toMap(SequencesKt.map(MapsKt.asSequence(ingredients), TBPRecipeConverter::mapIngredients$lambda$0));
    }

    private static final Pair mapIngredients$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        String string = ((Ingredient)entry.getKey()).getKey();
        Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
        Component component = ((Ingredient)entry.getKey()).displayName();
        Intrinsics.checkNotNullExpressionValue(component, "displayName(...)");
        return TuplesKt.to(new dev.jsinco.recipes.core.process.Ingredient(string, component), entry.getValue());
    }
}

