/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.util;

import dev.jsinco.recipes.util.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Ldev/jsinco/recipes/util/FileUtil;", "", "<init>", "()V", "saveResourceIfExists", "", "internalLocation", "", "destinationFile", "Ljava/io/File;", "replace", "", "makeFile", "file", "Recipes"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveResourceIfExists(@NotNull String internalLocation, @NotNull File destinationFile, boolean replace) {
        block14: {
            Intrinsics.checkNotNullParameter(internalLocation, "internalLocation");
            Intrinsics.checkNotNullParameter(destinationFile, "destinationFile");
            try {
                InputStream inputStream = INSTANCE.getClass().getResourceAsStream(internalLocation);
                if (inputStream == null) break block14;
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    long l;
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl = false;
                    if (!replace && destinationFile.exists()) {
                        return;
                    }
                    INSTANCE.makeFile(destinationFile);
                    Closeable closeable2 = new FileOutputStream(destinationFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)closeable2;
                        boolean bl2 = false;
                        l = inputStream2.transferTo(outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, throwable2);
                    }
                    Long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                Logger.INSTANCE.logErr(e);
            }
        }
    }

    public final void makeFile(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can not create parent directory for: " + file);
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create new file: " + file);
        }
    }
}

