/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.gui.integration;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.gui.integration.GuiIntegration;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Ldev/jsinco/recipes/gui/integration/TbpGuiInterface;", "Ldev/jsinco/recipes/gui/integration/GuiIntegration;", "<init>", "()V", "tbpApi", "Ldev/jsinco/brewery/bukkit/api/TheBrewingProjectApi;", "getTbpApi", "()Ldev/jsinco/brewery/bukkit/api/TheBrewingProjectApi;", "setTbpApi", "(Ldev/jsinco/brewery/bukkit/api/TheBrewingProjectApi;)V", "getApi", "createItem", "Lorg/bukkit/inventory/ItemStack;", "recipeView", "Ldev/jsinco/recipes/core/RecipeView;", "brewDisplayName", "Lnet/kyori/adventure/text/Component;", "identifier", "", "Recipes"})
public final class TbpGuiInterface
implements GuiIntegration {
    @NotNull
    public static final TbpGuiInterface INSTANCE = new TbpGuiInterface();
    public static TheBrewingProjectApi tbpApi;

    private TbpGuiInterface() {
    }

    @NotNull
    public final TheBrewingProjectApi getTbpApi() {
        TheBrewingProjectApi theBrewingProjectApi = tbpApi;
        if (theBrewingProjectApi != null) {
            return theBrewingProjectApi;
        }
        Intrinsics.throwUninitializedPropertyAccessException("tbpApi");
        return null;
    }

    public final void setTbpApi(@NotNull TheBrewingProjectApi theBrewingProjectApi) {
        Intrinsics.checkNotNullParameter(theBrewingProjectApi, "<set-?>");
        tbpApi = theBrewingProjectApi;
    }

    @NotNull
    public final TheBrewingProjectApi getApi() {
        if (tbpApi == null) {
            Object object = Bukkit.getServicesManager().load(TheBrewingProjectApi.class);
            Intrinsics.checkNotNull(object);
            this.setTbpApi((TheBrewingProjectApi)object);
        }
        return this.getTbpApi();
    }

    @Override
    @Nullable
    public ItemStack createItem(@NotNull RecipeView recipeView) {
        Intrinsics.checkNotNullParameter(recipeView, "recipeView");
        Optional optional = this.getApi().getRecipeRegistry().getRecipe(recipeView.getRecipeIdentifier());
        Intrinsics.checkNotNullExpressionValue(optional, "getRecipe(...)");
        Recipe recipe = (Recipe)OptionalsKt.getOrNull(optional);
        if (recipe == null) {
            return null;
        }
        Recipe recipe2 = recipe;
        RecipeResult recipeResult = recipe2.getRecipeResult(BrewQuality.EXCELLENT);
        Intrinsics.checkNotNull(recipeResult, "null cannot be cast to non-null type dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult");
        BukkitRecipeResult result = (BukkitRecipeResult)recipeResult;
        Brew brew = this.getApi().getBrewManager().createBrew(recipe2.getSteps());
        ItemStack item = result.newBrewItem(brew.score(recipe2), brew, (Brew.State)new Brew.State.Brewing());
        return item;
    }

    @Override
    @Nullable
    public Component brewDisplayName(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Optional optional = this.getApi().getRecipeRegistry().getRecipe(identifier);
        Intrinsics.checkNotNullExpressionValue(optional, "getRecipe(...)");
        Recipe recipe = (Recipe)OptionalsKt.getOrNull(optional);
        if (recipe == null) {
            return null;
        }
        Recipe recipe2 = recipe;
        MiniMessage miniMessage = MiniMessage.miniMessage();
        RecipeResult recipeResult = recipe2.getRecipeResult(BrewQuality.EXCELLENT);
        Intrinsics.checkNotNull(recipeResult, "null cannot be cast to non-null type dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult");
        return miniMessage.deserialize((Object)((BukkitRecipeResult)recipeResult).getName());
    }
}

