/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.data.serdes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.recipes.core.flaws.Flaw;
import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawExtent;
import dev.jsinco.recipes.core.flaws.type.CorrectionFlawType;
import dev.jsinco.recipes.core.flaws.type.FlawType;
import dev.jsinco.recipes.core.flaws.type.InaccuracyFlawType;
import dev.jsinco.recipes.core.flaws.type.ObfuscationFlawType;
import dev.jsinco.recipes.core.flaws.type.ReplacementFlawType;
import dev.jsinco.recipes.core.flaws.type.SlurringFlawType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Ldev/jsinco/recipes/data/serdes/FlawSerdes;", "", "<init>", "()V", "serializeFlaw", "Lcom/google/gson/JsonElement;", "flaw", "Ldev/jsinco/recipes/core/flaws/Flaw;", "deserializeFlaw", "json", "serializeFlawConfig", "config", "Ldev/jsinco/recipes/core/flaws/FlawConfig;", "deserializeFlawConfig", "serializeFlawExtent", "extent", "Ldev/jsinco/recipes/core/flaws/FlawExtent;", "deserializeFlawExtent", "serializeFlawType", "flawType", "Ldev/jsinco/recipes/core/flaws/type/FlawType;", "deserializeFlawType", "Recipes"})
public final class FlawSerdes {
    @NotNull
    public static final FlawSerdes INSTANCE = new FlawSerdes();

    private FlawSerdes() {
    }

    @NotNull
    public final JsonElement serializeFlaw(@NotNull Flaw flaw) {
        Intrinsics.checkNotNullParameter(flaw, "flaw");
        JsonObject output = new JsonObject();
        output.add("type", this.serializeFlawType(flaw.getType()));
        output.add("config", this.serializeFlawConfig(flaw.getConfig()));
        return (JsonElement)output;
    }

    @Nullable
    public final Flaw deserializeFlaw(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter(json, "json");
        if (!(json instanceof JsonObject)) {
            return null;
        }
        JsonElement jsonElement = ((JsonObject)json).get("type");
        Intrinsics.checkNotNullExpressionValue(jsonElement, "get(...)");
        FlawType flawType = this.deserializeFlawType(jsonElement);
        if (flawType == null) {
            return null;
        }
        FlawType type = flawType;
        JsonElement jsonElement2 = ((JsonObject)json).get("config");
        Intrinsics.checkNotNullExpressionValue(jsonElement2, "get(...)");
        FlawConfig flawConfig = this.deserializeFlawConfig(jsonElement2);
        if (flawConfig == null) {
            return null;
        }
        FlawConfig config = flawConfig;
        return new Flaw(type, config);
    }

    private final JsonElement serializeFlawConfig(FlawConfig config) {
        JsonObject output = new JsonObject();
        output.add("extent", this.serializeFlawExtent(config.getExtent()));
        output.addProperty("seed", (Number)config.getSeed());
        output.addProperty("intensity", (Number)config.getIntensity());
        return (JsonElement)output;
    }

    private final FlawConfig deserializeFlawConfig(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            return null;
        }
        JsonElement jsonElement = ((JsonObject)json).get("extent");
        Intrinsics.checkNotNullExpressionValue(jsonElement, "get(...)");
        FlawExtent flawExtent = this.deserializeFlawExtent(jsonElement);
        if (flawExtent == null) {
            return null;
        }
        FlawExtent extent = flawExtent;
        int seed = ((JsonObject)json).get("seed").getAsInt();
        double intensity = ((JsonObject)json).get("intensity").getAsDouble();
        return new FlawConfig(extent, seed, intensity);
    }

    private final JsonElement serializeFlawExtent(FlawExtent extent) {
        JsonObject output = new JsonObject();
        FlawExtent flawExtent = extent;
        if (flawExtent instanceof FlawExtent.Everywhere) {
            output.addProperty("type", "everywhere");
        } else if (flawExtent instanceof FlawExtent.WholeStep) {
            output.addProperty("type", "whole_step");
            output.addProperty("step-index", (Number)((FlawExtent.WholeStep)extent).getStepIndex());
        } else if (flawExtent instanceof FlawExtent.StepRange) {
            output.addProperty("type", "partial_step");
            output.addProperty("step-index", (Number)((FlawExtent.StepRange)extent).getStepIndex());
            output.addProperty("start", (Number)((FlawExtent.StepRange)extent).getStart());
            output.addProperty("stop", (Number)((FlawExtent.StepRange)extent).getStop());
        } else if (flawExtent instanceof FlawExtent.AfterPoint) {
            output.addProperty("type", "after");
            output.addProperty("step-index", (Number)((FlawExtent.AfterPoint)extent).getStepIndex());
            output.addProperty("start", (Number)((FlawExtent.AfterPoint)extent).getStart());
        } else {
            throw new IllegalStateException("Unknown flaw extent");
        }
        return (JsonElement)output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FlawExtent deserializeFlawExtent(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            return null;
        }
        String string = ((JsonObject)json).get("type").getAsString();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 610975434: {
                if (string.equals("partial_step")) {
                    n = 1;
                }
                break;
            }
            case 404357804: {
                if (string.equals("everywhere")) {
                    n = 2;
                }
                break;
            }
            case -679585708: {
                if (string.equals("whole_step")) {
                    n = 3;
                }
                break;
            }
            case 92734940: {
                if (string.equals("after")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                FlawExtent flawExtent = FlawExtent.Everywhere.INSTANCE;
                return flawExtent;
            }
            case 3: {
                FlawExtent flawExtent = new FlawExtent.WholeStep(((JsonObject)json).get("step-index").getAsInt());
                return flawExtent;
            }
            case 1: {
                FlawExtent flawExtent = new FlawExtent.StepRange(((JsonObject)json).get("step-index").getAsInt(), ((JsonObject)json).get("start").getAsInt(), ((JsonObject)json).get("stop").getAsInt());
                return flawExtent;
            }
            case 4: {
                FlawExtent flawExtent = new FlawExtent.AfterPoint(((JsonObject)json).get("step-index").getAsInt(), ((JsonObject)json).get("start").getAsInt());
                return flawExtent;
            }
            default: {
                return null;
            }
        }
    }

    private final JsonElement serializeFlawType(FlawType flawType) {
        JsonObject output = new JsonObject();
        FlawType flawType2 = flawType;
        if (flawType2 instanceof InaccuracyFlawType) {
            output.addProperty("type", "inaccuracy");
        } else if (flawType2 instanceof ReplacementFlawType) {
            output.addProperty("type", "replacement");
            output.addProperty("chars", ((ReplacementFlawType)flawType).getReplacement());
        } else if (flawType2 instanceof ObfuscationFlawType) {
            output.addProperty("type", "obfuscation");
        } else if (flawType2 instanceof SlurringFlawType) {
            output.addProperty("type", "slurring");
        } else if (flawType2 instanceof CorrectionFlawType) {
            output.addProperty("type", "correction");
        } else {
            throw new IllegalStateException("Unknown flaw type");
        }
        return (JsonElement)output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FlawType deserializeFlawType(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            return null;
        }
        String string = ((JsonObject)json).get("type").getAsString();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 1752682782: {
                if (string.equals("inaccuracy")) {
                    n = 1;
                }
                break;
            }
            case 1155669854: {
                if (string.equals("correction")) {
                    n = 2;
                }
                break;
            }
            case 430919186: {
                if (string.equals("replacement")) {
                    n = 3;
                }
                break;
            }
            case 308161155: {
                if (string.equals("obfuscation")) {
                    n = 4;
                }
                break;
            }
            case -915731994: {
                if (string.equals("slurring")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                FlawType flawType = InaccuracyFlawType.INSTANCE;
                return flawType;
            }
            case 3: {
                JsonElement jsonElement = ((JsonObject)json).get("chars");
                if (jsonElement == null) {
                    return null;
                }
                JsonElement replacement = jsonElement;
                String string2 = replacement.getAsString();
                Intrinsics.checkNotNullExpressionValue(string2, "getAsString(...)");
                FlawType flawType = new ReplacementFlawType(string2, false, 2, null);
                return flawType;
            }
            case 4: {
                FlawType flawType = ObfuscationFlawType.INSTANCE;
                return flawType;
            }
            case 5: {
                FlawType flawType = SlurringFlawType.INSTANCE;
                return flawType;
            }
            case 2: {
                FlawType flawType = CorrectionFlawType.INSTANCE;
                return flawType;
            }
            default: {
                return null;
            }
        }
    }
}

