/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.data;

import dev.jsinco.recipes.Recipes;
import dev.jsinco.recipes.data.StorageImpl;
import dev.jsinco.recipes.data.StorageType;
import dev.jsinco.recipes.data.storage.MySQLStorageImpl;
import dev.jsinco.recipes.data.storage.SQLiteStorageImpl;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Ldev/jsinco/recipes/data/DataManager;", "", "dataFolder", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getDataFolder", "()Ljava/io/File;", "storageImpl", "Ldev/jsinco/recipes/data/StorageImpl;", "getStorageImpl", "()Ldev/jsinco/recipes/data/StorageImpl;", "createStorage", "type", "Ldev/jsinco/recipes/data/StorageType;", "Recipes"})
public final class DataManager {
    @NotNull
    private final File dataFolder;
    @NotNull
    private final StorageImpl storageImpl;

    public DataManager(@NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.dataFolder = dataFolder;
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.storageImpl = this.createStorage(StorageType.Companion.fromString(Recipes.Companion.getRecipesConfig().getStorage().getType()));
        this.storageImpl.createTables();
    }

    @NotNull
    public final File getDataFolder() {
        return this.dataFolder;
    }

    @NotNull
    public final StorageImpl getStorageImpl() {
        return this.storageImpl;
    }

    private final StorageImpl createStorage(StorageType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> new SQLiteStorageImpl(this.dataFolder);
            case 2 -> new MySQLStorageImpl();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.SQLite.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.MySQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

