/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import dev.jsinco.recipes.Recipes;
import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawTextModificationWriter;
import dev.jsinco.recipes.core.flaws.FlawTextModifications;
import dev.jsinco.recipes.core.flaws.drunkentext.DrunkenTextReplacement;
import dev.jsinco.recipes.core.flaws.type.FlawType;
import dev.jsinco.recipes.data.serdes.DrunkenTextSerdes;
import dev.jsinco.recipes.data.serdes.Serdes;
import dev.jsinco.recipes.util.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/jsinco/recipes/core/flaws/type/SlurringFlawType;", "Ldev/jsinco/recipes/core/flaws/type/FlawType;", "<init>", "()V", "drunkenReplacements", "", "Ldev/jsinco/recipes/core/flaws/drunkentext/DrunkenTextReplacement;", "retrieveDrunkenReplacements", "postProcess", "Lnet/kyori/adventure/text/Component;", "text", "", "pos", "", "config", "Ldev/jsinco/recipes/core/flaws/FlawConfig;", "findFlawModifications", "Ldev/jsinco/recipes/core/flaws/FlawTextModifications;", "component", "session", "Ldev/jsinco/recipes/core/flaws/type/FlawType$ModificationFindSession;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nSlurringFlawType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlurringFlawType.kt\ndev/jsinco/recipes/core/flaws/type/SlurringFlawType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1869#2,2:63\n*S KotlinDebug\n*F\n+ 1 SlurringFlawType.kt\ndev/jsinco/recipes/core/flaws/type/SlurringFlawType\n*L\n54#1:63,2\n*E\n"})
public final class SlurringFlawType
implements FlawType {
    @NotNull
    public static final SlurringFlawType INSTANCE = new SlurringFlawType();
    @NotNull
    private static final List<DrunkenTextReplacement> drunkenReplacements = INSTANCE.retrieveDrunkenReplacements();

    private SlurringFlawType() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<DrunkenTextReplacement> retrieveDrunkenReplacements() {
        File destinationFile = new File(Recipes.Companion.getInstance().getDataFolder(), "locale/" + Recipes.Companion.getRecipesConfig().getLanguage().toLanguageTag() + ".drunk_text.json");
        FileUtil.INSTANCE.saveResourceIfExists("/locale/en-US.drunk_text.json", destinationFile, false);
        Closeable closeable = new FileInputStream(destinationFile);
        Throwable throwable = null;
        try {
            List<DrunkenTextReplacement> list;
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new InputStreamReader(inputStream);
            Throwable throwable2 = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable2;
                boolean bl2 = false;
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
                list = Serdes.INSTANCE.deserializeList(jsonArray, DrunkenTextSerdes.INSTANCE::deserialize);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally(closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable2);
            List<DrunkenTextReplacement> list2 = list;
            return list2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    @NotNull
    public Component postProcess(@NotNull String text, int pos, @NotNull FlawConfig config) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        TextComponent textComponent = Component.text((String)text);
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        return (Component)textComponent;
    }

    @Override
    @NotNull
    public FlawTextModifications findFlawModifications(@NotNull Component component, @NotNull FlawType.ModificationFindSession session) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(session, "session");
        FlawTextModifications flawTextModifications = new FlawTextModifications();
        FlawConfig config = session.getConfig();
        FlawTextModificationWriter.INSTANCE.traverse(component, (arg_0, arg_1) -> SlurringFlawType.findFlawModifications$lambda$0(config, session, flawTextModifications, arg_0, arg_1));
        return flawTextModifications;
    }

    private static final void findFlawModifications$lambda$0(FlawConfig $config, FlawType.ModificationFindSession $session, FlawTextModifications $flawTextModifications, String text, Integer startPos) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        List<DrunkenTextReplacement> replacements = drunkenReplacements;
        for (DrunkenTextReplacement replacement : replacements) {
            List<DrunkenTextReplacement.Replacement> found = replacement.replacements(text, $config.getSeed(), startPos, arg_0 -> SlurringFlawType.findFlawModifications$lambda$0$0($session, arg_0));
            Iterable $this$forEach$iv = found;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DrunkenTextReplacement.Replacement it = (DrunkenTextReplacement.Replacement)element$iv;
                boolean bl = false;
                $flawTextModifications.write(it.getPos(), it.getReplacement(), replacement.getFaultLevel());
            }
        }
    }

    private static final boolean findFlawModifications$lambda$0$0(FlawType.ModificationFindSession $session, Integer pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return $session.appliesTo(pos);
    }
}

