/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws.type;

import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawTextModificationWriter;
import dev.jsinco.recipes.core.flaws.FlawTextModifications;
import dev.jsinco.recipes.core.flaws.type.FlawType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ldev/jsinco/recipes/core/flaws/type/InaccuracyFlawType;", "Ldev/jsinco/recipes/core/flaws/type/FlawType;", "<init>", "()V", "NUMBER_REGEX", "Lkotlin/text/Regex;", "getNUMBER_REGEX", "()Lkotlin/text/Regex;", "transformNumber", "", "text", "", "pos", "", "config", "Ldev/jsinco/recipes/core/flaws/FlawConfig;", "changeNumber", "", "original", "numberStart", "postProcess", "Lnet/kyori/adventure/text/Component;", "findFlawModifications", "Ldev/jsinco/recipes/core/flaws/FlawTextModifications;", "component", "session", "Ldev/jsinco/recipes/core/flaws/type/FlawType$ModificationFindSession;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nInaccuracyFlawType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InaccuracyFlawType.kt\ndev/jsinco/recipes/core/flaws/type/InaccuracyFlawType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1563#2:81\n1634#2,3:82\n1761#2,3:85\n*S KotlinDebug\n*F\n+ 1 InaccuracyFlawType.kt\ndev/jsinco/recipes/core/flaws/type/InaccuracyFlawType\n*L\n56#1:81\n56#1:82,3\n57#1:85,3\n*E\n"})
public final class InaccuracyFlawType
implements FlawType {
    @NotNull
    public static final InaccuracyFlawType INSTANCE = new InaccuracyFlawType();
    @NotNull
    private static final Regex NUMBER_REGEX = new Regex("[+-]?([0-9]*[.])?[0-9]+");

    private InaccuracyFlawType() {
    }

    @NotNull
    public final Regex getNUMBER_REGEX() {
        return NUMBER_REGEX;
    }

    @NotNull
    public final Number transformNumber(@NotNull String text, int pos, @NotNull FlawConfig config) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        double newNumber = this.changeNumber(Double.parseDouble(text), pos, config);
        return StringsKt.contains$default((CharSequence)text, ".", false, 2, null) ? (Number)newNumber : (Number)MathKt.roundToInt(newNumber);
    }

    private final double changeNumber(double original, int numberStart, FlawConfig config) {
        double intensity = config.getIntensity();
        int seed = config.getSeed();
        if (intensity <= 15.0) {
            return original;
        }
        double scale = RangesKt.coerceIn(intensity, 15.0, 100.0) / 100.0;
        double range = scale * original / (double)2;
        Random rng = RandomKt.Random(seed + numberStart);
        double offset = rng.nextDouble(-range, range);
        return original + offset;
    }

    @Override
    @NotNull
    public Component postProcess(@NotNull String text, int pos, @NotNull FlawConfig config) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        TextComponent textComponent = Component.text((String)text);
        Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
        return (Component)textComponent;
    }

    @Override
    @NotNull
    public FlawTextModifications findFlawModifications(@NotNull Component component, @NotNull FlawType.ModificationFindSession session) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(session, "session");
        FlawTextModifications flawTextModifications = new FlawTextModifications();
        FlawConfig config = session.getConfig();
        FlawTextModificationWriter.INSTANCE.traverse(component, NUMBER_REGEX, (arg_0, arg_1) -> InaccuracyFlawType.findFlawModifications$lambda$0(config, flawTextModifications, session, arg_0, arg_1));
        return flawTextModifications;
    }

    /*
     * WARNING - void declaration
     */
    private static final void findFlawModifications$lambda$0(FlawConfig $config, FlawTextModifications $flawTextModifications, FlawType.ModificationFindSession $session, String text, Integer startPos) {
        boolean bl;
        block8: {
            void $this$any$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(startPos, "startPos");
            Iterable iterable = RangesKt.until(0, text.length());
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(startPos + it);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (!(!$session.appliesTo(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Number newNumber = INSTANCE.transformNumber(text, startPos, $config);
        String numberString = newNumber.toString();
        if (Intrinsics.areEqual(text, numberString)) {
            return;
        }
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            Object content;
            Object object = content = i < numberString.length() ? String.valueOf(numberString.charAt(i)) : "";
            if (i == text.length() - 1 && numberString.length() > text.length()) {
                String string = numberString.substring(i);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                content = (String)content + string;
            }
            $flawTextModifications.write(i + startPos, (String)content, Math.abs(Double.parseDouble(text) - newNumber.doubleValue()) / newNumber.doubleValue() * (double)4);
        }
    }
}

