/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws.creation;

import dev.jsinco.recipes.core.BreweryRecipe;
import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.core.RecipeWriter;
import dev.jsinco.recipes.core.flaws.Flaw;
import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawExtent;
import dev.jsinco.recipes.core.flaws.creation.RecipeViewCreator;
import dev.jsinco.recipes.core.flaws.type.CorrectionFlawType;
import dev.jsinco.recipes.core.flaws.type.FlawType;
import dev.jsinco.recipes.core.flaws.type.InaccuracyFlawType;
import dev.jsinco.recipes.core.flaws.type.ReplacementFlawType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/jsinco/recipes/core/flaws/creation/UncertainRecipeViewCreator;", "Ldev/jsinco/recipes/core/flaws/creation/RecipeViewCreator;", "<init>", "()V", "create", "Ldev/jsinco/recipes/core/RecipeView;", "breweryRecipe", "Ldev/jsinco/recipes/core/BreweryRecipe;", "expectedFlawLevel", "", "Recipes"})
public final class UncertainRecipeViewCreator
implements RecipeViewCreator {
    @NotNull
    public static final UncertainRecipeViewCreator INSTANCE = new UncertainRecipeViewCreator();

    private UncertainRecipeViewCreator() {
    }

    @Override
    @NotNull
    public RecipeView create(@NotNull BreweryRecipe breweryRecipe, double expectedFlawLevel) {
        Intrinsics.checkNotNullParameter(breweryRecipe, "breweryRecipe");
        double arbitraryTargetFlawIntensity = expectedFlawLevel * 0.4;
        double flawIntensity = 0.0;
        List flaws = new ArrayList();
        while (arbitraryTargetFlawIntensity > flawIntensity) {
            int random1 = Random.Default.nextInt(3);
            FlawType flawType = switch (random1) {
                case 0 -> new ReplacementFlawType("?", false, 2, null);
                case 1 -> InaccuracyFlawType.INSTANCE;
                case 2 -> CorrectionFlawType.INSTANCE;
                default -> throw new IllegalStateException("Unreachable code, someone messed up");
            };
            FlawExtent extent = switch (random1) {
                case 0, 2 -> {
                    if (Random.Default.nextInt(2) == 1) {
                        yield FlawExtent.Companion.compileAfterPoint(breweryRecipe.getSteps().size());
                    }
                    yield FlawExtent.Companion.compileStepRange(breweryRecipe.getSteps().size());
                }
                default -> {
                    switch (Random.Default.nextInt(3)) {
                        case 0: {
                            yield FlawExtent.Everywhere.INSTANCE;
                        }
                        case 1: {
                            yield FlawExtent.Companion.compileStepRange(breweryRecipe.getSteps().size());
                        }
                        case 2: {
                            yield FlawExtent.Companion.compileWholeStep(breweryRecipe.getSteps().size());
                        }
                    }
                    throw new IllegalStateException("Unreachable code, someone messed up");
                }
            };
            flaws.add(new Flaw(flawType, new FlawConfig(extent, Random.Default.nextInt(), expectedFlawLevel)));
            flawIntensity = RecipeWriter.INSTANCE.estimateFragmentation(RecipeView.Companion.of(breweryRecipe.getIdentifier(), flaws));
        }
        return RecipeWriter.clearRedundantFlaws$default(RecipeWriter.INSTANCE, RecipeView.Companion.of(breweryRecipe.getIdentifier(), flaws), 0.0, 2, null);
    }
}

