/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws.creation;

import dev.jsinco.recipes.core.BreweryRecipe;
import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.core.flaws.Flaw;
import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawExtent;
import dev.jsinco.recipes.core.flaws.creation.RecipeViewCreator;
import dev.jsinco.recipes.core.flaws.type.InaccuracyFlawType;
import dev.jsinco.recipes.core.flaws.type.ReplacementFlawType;
import dev.jsinco.recipes.core.flaws.type.SlurringFlawType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/jsinco/recipes/core/flaws/creation/DrunkRecipeViewCreator;", "Ldev/jsinco/recipes/core/flaws/creation/RecipeViewCreator;", "<init>", "()V", "create", "Ldev/jsinco/recipes/core/RecipeView;", "breweryRecipe", "Ldev/jsinco/recipes/core/BreweryRecipe;", "expectedFlawLevel", "", "Recipes"})
public final class DrunkRecipeViewCreator
implements RecipeViewCreator {
    @NotNull
    public static final DrunkRecipeViewCreator INSTANCE = new DrunkRecipeViewCreator();

    private DrunkRecipeViewCreator() {
    }

    @Override
    @NotNull
    public RecipeView create(@NotNull BreweryRecipe breweryRecipe, double expectedFlawLevel) {
        Intrinsics.checkNotNullParameter(breweryRecipe, "breweryRecipe");
        List flaws = new ArrayList();
        if (Random.Default.nextBoolean() && expectedFlawLevel > 40.0) {
            flaws.add(new Flaw(new ReplacementFlawType(".", true), new FlawConfig(FlawExtent.Companion.compileAfterPoint(breweryRecipe.getSteps().size()), Random.Default.nextInt(), 100.0)));
        }
        flaws.add(new Flaw(SlurringFlawType.INSTANCE, new FlawConfig(FlawExtent.Everywhere.INSTANCE, Random.Default.nextInt(), expectedFlawLevel)));
        flaws.add(new Flaw(InaccuracyFlawType.INSTANCE, new FlawConfig(FlawExtent.Everywhere.INSTANCE, Random.Default.nextInt(), expectedFlawLevel)));
        return RecipeView.Companion.of(breweryRecipe.getIdentifier(), flaws);
    }
}

