/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core.flaws;

import dev.jsinco.recipes.core.flaws.Flaw;
import dev.jsinco.recipes.core.flaws.FlawConfig;
import dev.jsinco.recipes.core.flaws.FlawTextModifications;
import dev.jsinco.recipes.core.flaws.type.FlawType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.MatchResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ2\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002J<\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001fJ(\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00142\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0002\u00a8\u0006!"}, d2={"Ldev/jsinco/recipes/core/flaws/FlawTextModificationWriter;", "", "<init>", "()V", "traverse", "", "text", "Lnet/kyori/adventure/text/Component;", "consumer", "Ljava/util/function/BiConsumer;", "", "", "regex", "Lkotlin/text/Regex;", "process", "textModifications", "Ldev/jsinco/recipes/core/flaws/FlawTextModifications;", "flaw", "Ldev/jsinco/recipes/core/flaws/Flaw;", "offsets", "", "findInvalid", "", "randomPositionReplacement", "modificationFindSession", "Ldev/jsinco/recipes/core/flaws/type/FlawType$ModificationFindSession;", "individualFlawIntensity", "", "overwriteSpace", "", "textInfo", "Lkotlin/Function1;", "invertOffsets", "Recipes"})
@SourceDebugExtension(value={"SMAP\nFlawTextModificationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlawTextModificationWriter.kt\ndev/jsinco/recipes/core/flaws/FlawTextModificationWriter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,143:1\n1321#2,2:144\n*S KotlinDebug\n*F\n+ 1 FlawTextModificationWriter.kt\ndev/jsinco/recipes/core/flaws/FlawTextModificationWriter\n*L\n29#1:144,2\n*E\n"})
public final class FlawTextModificationWriter {
    @NotNull
    public static final FlawTextModificationWriter INSTANCE = new FlawTextModificationWriter();

    private FlawTextModificationWriter() {
    }

    public final void traverse(@NotNull Component text, @NotNull BiConsumer<String, Integer> consumer) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        text.replaceText(arg_0 -> FlawTextModificationWriter.traverse$lambda$0(consumer, arg_0));
    }

    public final void traverse(@NotNull Component text, @NotNull Regex regex, @NotNull BiConsumer<String, Integer> consumer) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(regex, "regex");
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        text.replaceText(arg_0 -> FlawTextModificationWriter.traverse$lambda$1(regex, consumer, arg_0));
    }

    @NotNull
    public final Component process(@NotNull Component text, @NotNull FlawTextModifications textModifications, @NotNull Flaw flaw, @NotNull Map<Integer, Integer> offsets) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(textModifications, "textModifications");
        Intrinsics.checkNotNullParameter(flaw, "flaw");
        Intrinsics.checkNotNullParameter(offsets, "offsets");
        Component component = text.replaceText(arg_0 -> FlawTextModificationWriter.process$lambda$0(offsets, textModifications, flaw, arg_0));
        Intrinsics.checkNotNullExpressionValue(component, "replaceText(...)");
        return component;
    }

    private final Set<Integer> findInvalid(Map<Integer, Integer> offsets) {
        if (offsets.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set output = new LinkedHashSet();
        int currentOffset = 0;
        int n = ((Number)CollectionsKt.maxOrThrow((Iterable)offsets.keySet())).intValue() + 1;
        for (int i = 0; i < n; ++i) {
            int currentPos;
            Integer n2 = offsets.get(i);
            if (n2 == null) {
                continue;
            }
            int offset = n2;
            int n3 = currentPos + offset;
            for (int pos = currentPos = i + currentOffset; pos < n3; ++pos) {
                output.add(pos + 1);
            }
            currentOffset += offset;
        }
        return output;
    }

    @NotNull
    public final FlawTextModifications randomPositionReplacement(@NotNull Component text, @NotNull FlawType.ModificationFindSession modificationFindSession, double individualFlawIntensity, boolean overwriteSpace, @NotNull Function1<? super String, String> textInfo) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(modificationFindSession, "modificationFindSession");
        Intrinsics.checkNotNullParameter(textInfo, "textInfo");
        FlawTextModifications flawTextModifications = new FlawTextModifications();
        FlawConfig config = modificationFindSession.getConfig();
        if (config.getIntensity() == 0.0) {
            return flawTextModifications;
        }
        this.traverse(text, (arg_0, arg_1) -> FlawTextModificationWriter.randomPositionReplacement$lambda$0(config, overwriteSpace, modificationFindSession, flawTextModifications, textInfo, individualFlawIntensity, arg_0, arg_1));
        return flawTextModifications;
    }

    public static /* synthetic */ FlawTextModifications randomPositionReplacement$default(FlawTextModificationWriter flawTextModificationWriter, Component component, FlawType.ModificationFindSession modificationFindSession, double d, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return flawTextModificationWriter.randomPositionReplacement(component, modificationFindSession, d, bl, function1);
    }

    private final Map<Integer, Integer> invertOffsets(Map<Integer, Integer> offsets) {
        Map output = new LinkedHashMap();
        for (Map.Entry<Integer, Integer> entry : offsets.entrySet()) {
            output.put(((Number)entry.getKey()).intValue() + ((Number)entry.getValue()).intValue(), -((Number)entry.getValue()).intValue());
        }
        return output;
    }

    private static final void traverse$lambda$0(BiConsumer $consumer, TextReplacementConfig.Builder it) {
        Ref.IntRef pos = new Ref.IntRef();
        it.match(".+").replacement((arg_0, arg_1) -> FlawTextModificationWriter.traverse$lambda$0$0(pos, $consumer, arg_0, arg_1));
    }

    private static final ComponentLike traverse$lambda$0$0(Ref.IntRef $pos, BiConsumer $consumer, MatchResult matchResult, TextComponent.Builder builder) {
        String everything = matchResult.group();
        int prevPos = $pos.element;
        $pos.element += everything.length();
        $consumer.accept(everything, matchResult.start() + prevPos);
        return (ComponentLike)Component.text((String)everything);
    }

    private static final void traverse$lambda$1(Regex $regex, BiConsumer $consumer, TextReplacementConfig.Builder it) {
        Ref.IntRef pos = new Ref.IntRef();
        it.match(".+").replacement((arg_0, arg_1) -> FlawTextModificationWriter.traverse$lambda$1$0($regex, pos, $consumer, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private static final ComponentLike traverse$lambda$1$0(Regex $regex, Ref.IntRef $pos, BiConsumer $consumer, MatchResult matchResult, TextComponent.Builder builder) {
        void $this$forEach$iv;
        String everything = matchResult.group();
        Intrinsics.checkNotNull(everything);
        Sequence sequence = Regex.findAll$default($regex, everything, 0, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            kotlin.text.MatchResult matchResult1 = (kotlin.text.MatchResult)element$iv;
            boolean bl = false;
            $consumer.accept(matchResult1.getValue(), matchResult1.getRange().getStart() + $pos.element);
        }
        $pos.element += everything.length();
        return (ComponentLike)Component.text((String)everything);
    }

    private static final void process$lambda$0(Map $offsets, FlawTextModifications $textModifications, Flaw $flaw, TextReplacementConfig.Builder it) {
        Ref.IntRef pos = new Ref.IntRef();
        Map<Integer, Integer> invertedOffsets = INSTANCE.invertOffsets($offsets);
        Set<Integer> invalidPoints = INSTANCE.findInvalid($offsets);
        Ref.IntRef offset = new Ref.IntRef();
        it.match(".+").replacement((arg_0, arg_1) -> FlawTextModificationWriter.process$lambda$0$0(pos, offset, $textModifications, invalidPoints, $flaw, invertedOffsets, arg_0, arg_1));
    }

    private static final ComponentLike process$lambda$0$0(Ref.IntRef $pos, Ref.IntRef $offset, FlawTextModifications $textModifications, Set $invalidPoints, Flaw $flaw, Map $invertedOffsets, MatchResult matchResult, TextComponent.Builder builder) {
        Component component;
        int prevPos;
        int currentPos;
        String everything = matchResult.group();
        $pos.element += everything.length();
        TextComponent.Builder builder2 = Component.text();
        Intrinsics.checkNotNullExpressionValue(builder2, "text(...)");
        TextComponent.Builder builder3 = builder2;
        Object modifiedText = "";
        Object unmodifiedText = "";
        for (currentPos = prevPos = $pos.element; currentPos < $pos.element; ++currentPos) {
            int currentOffsetPos = currentPos + $offset.element;
            if ($textModifications.modifies(currentOffsetPos) && !$invalidPoints.contains(currentPos)) {
                if (((CharSequence)modifiedText).length() == 0) {
                    builder3.append((Component)Component.text((String)unmodifiedText));
                    unmodifiedText = "";
                }
                String string = $textModifications.get(currentOffsetPos);
                Intrinsics.checkNotNull(string);
                modifiedText = (String)modifiedText + string;
            } else {
                if (!(((CharSequence)modifiedText).length() == 0)) {
                    builder3.append($flaw.getType().postProcess((String)modifiedText, currentPos, $flaw.getConfig()));
                    modifiedText = "";
                }
                unmodifiedText = (String)unmodifiedText + everything.charAt(currentPos - prevPos);
            }
            if (!$invertedOffsets.containsKey(currentPos)) continue;
            Object v = $invertedOffsets.get(currentPos);
            Intrinsics.checkNotNull(v);
            $offset.element = ((Number)v).intValue();
        }
        if (((CharSequence)modifiedText).length() == 0) {
            TextComponent textComponent = Component.text((String)unmodifiedText);
            Intrinsics.checkNotNull(textComponent);
            component = (Component)textComponent;
        } else {
            component = $flaw.getType().postProcess((String)modifiedText, currentPos, $flaw.getConfig());
        }
        builder3.append(component);
        return (ComponentLike)builder3.build();
    }

    private static final void randomPositionReplacement$lambda$0(FlawConfig $config, boolean $overwriteSpace, FlawType.ModificationFindSession $modificationFindSession, FlawTextModifications $flawTextModifications, Function1 $textInfo, double $individualFlawIntensity, String string, Integer startPos) {
        Intrinsics.checkNotNullParameter(string, "string");
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        int pos = startPos;
        String string2 = string;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char character = string2.charAt(i);
            Random rng = RandomKt.Random($config.getSeed() + pos + character);
            if ((character != ' ' || $overwriteSpace) && $modificationFindSession.appliesTo(pos) && rng.nextDouble() < $config.getIntensity() / (double)100) {
                $flawTextModifications.write(pos, (String)$textInfo.invoke(String.valueOf(character)), $individualFlawIntensity);
            }
            ++pos;
        }
    }
}

