/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core;

import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.core.RecipeWriter;
import dev.jsinco.recipes.data.StorageImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Ldev/jsinco/recipes/core/RecipeViewManager;", "", "storageImpl", "Ldev/jsinco/recipes/data/StorageImpl;", "<init>", "(Ldev/jsinco/recipes/data/StorageImpl;)V", "backing", "", "Ljava/util/UUID;", "", "Ldev/jsinco/recipes/core/RecipeView;", "getBacking", "()Ljava/util/Map;", "getViews", "", "playerUuid", "insertOrUpdateView", "", "recipeView", "insertOrMergeView", "incoming", "removeView", "recipeKey", "", "clearAll", "Recipes"})
@SourceDebugExtension(value={"SMAP\nRecipeViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeViewManager.kt\ndev/jsinco/recipes/core/RecipeViewManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n360#2,7:62\n1869#2,2:69\n1#3:71\n*S KotlinDebug\n*F\n+ 1 RecipeViewManager.kt\ndev/jsinco/recipes/core/RecipeViewManager\n*L\n31#1:62,7\n57#1:69,2\n*E\n"})
public final class RecipeViewManager {
    @NotNull
    private final StorageImpl storageImpl;
    @NotNull
    private final Map<UUID, List<RecipeView>> backing;

    public RecipeViewManager(@NotNull StorageImpl storageImpl) {
        Intrinsics.checkNotNullParameter(storageImpl, "storageImpl");
        this.storageImpl = storageImpl;
        this.backing = new LinkedHashMap();
        this.storageImpl.selectAllRecipeViews().thenAcceptAsync(arg_0 -> RecipeViewManager._init_$lambda$1(arg_0 -> RecipeViewManager._init_$lambda$0(this, arg_0), arg_0));
    }

    @NotNull
    public final Map<UUID, List<RecipeView>> getBacking() {
        return this.backing;
    }

    @NotNull
    public final List<RecipeView> getViews(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        List<RecipeView> list = this.backing.get(playerUuid);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void insertOrUpdateView(@NotNull UUID playerUuid, @NotNull RecipeView recipeView) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(recipeView, "recipeView");
        List list = this.backing.computeIfAbsent(playerUuid, arg_0 -> RecipeViewManager.insertOrUpdateView$lambda$1(RecipeViewManager::insertOrUpdateView$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        List recipeViews = list;
        recipeViews.removeIf(arg_0 -> RecipeViewManager.insertOrUpdateView$lambda$3(arg_0 -> RecipeViewManager.insertOrUpdateView$lambda$2(recipeView, arg_0), arg_0));
        recipeViews.add(recipeView);
        this.storageImpl.insertOrUpdateRecipeView(playerUuid, recipeView);
    }

    public final void insertOrMergeView(@NotNull UUID playerUuid, @NotNull RecipeView incoming) {
        int idx;
        List list;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
            Intrinsics.checkNotNullParameter(incoming, "incoming");
            List list2 = this.backing.computeIfAbsent(playerUuid, arg_0 -> RecipeViewManager.insertOrMergeView$lambda$1(RecipeViewManager::insertOrMergeView$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(list2, "computeIfAbsent(...)");
            List $this$indexOfFirst$iv = list = list2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                RecipeView it = (RecipeView)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getRecipeIdentifier(), incoming.getRecipeIdentifier())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = idx = -1;
        }
        if (idx < 0) {
            RecipeView minimalized = RecipeWriter.clearRedundantFlaws$default(RecipeWriter.INSTANCE, incoming, 0.0, 2, null);
            list.add(minimalized);
            this.storageImpl.insertOrUpdateRecipeView(playerUuid, minimalized);
            return;
        }
        RecipeView existing = (RecipeView)list.get(idx);
        RecipeView merged = RecipeWriter.INSTANCE.mergeFlaws(existing, incoming);
        RecipeView minimalized = RecipeWriter.clearRedundantFlaws$default(RecipeWriter.INSTANCE, merged, 0.0, 2, null);
        list.set(idx, minimalized);
        this.storageImpl.insertOrUpdateRecipeView(playerUuid, minimalized);
    }

    public final void removeView(@NotNull UUID playerUuid, @NotNull String recipeKey) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        Intrinsics.checkNotNullParameter(recipeKey, "recipeKey");
        List list = this.backing.computeIfAbsent(playerUuid, arg_0 -> RecipeViewManager.removeView$lambda$1(RecipeViewManager::removeView$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        List recipeViews = list;
        recipeViews.removeIf(arg_0 -> RecipeViewManager.removeView$lambda$3(arg_0 -> RecipeViewManager.removeView$lambda$2(recipeKey, arg_0), arg_0));
        this.storageImpl.removeRecipeView(playerUuid, recipeKey);
    }

    public final void clearAll(@NotNull UUID playerUuid) {
        block1: {
            List<RecipeView> views;
            Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
            List<RecipeView> list = views = this.backing.remove(playerUuid);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RecipeView it = (RecipeView)element$iv;
                boolean bl = false;
                this.storageImpl.removeRecipeView(playerUuid, it.getRecipeIdentifier());
            }
        }
    }

    private static final Unit _init_$lambda$0(RecipeViewManager this$0, Map it) {
        block0: {
            Map map = it;
            if (map == null) break block0;
            Map it2 = map;
            boolean bl = false;
            this$0.backing.putAll(it2);
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final List insertOrUpdateView$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List insertOrUpdateView$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean insertOrUpdateView$lambda$2(RecipeView $recipeView, RecipeView it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRecipeIdentifier(), $recipeView.getRecipeIdentifier());
    }

    private static final boolean insertOrUpdateView$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final List insertOrMergeView$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List insertOrMergeView$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List removeView$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List removeView$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final boolean removeView$lambda$2(String $recipeKey, RecipeView it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRecipeIdentifier(), $recipeKey);
    }

    private static final boolean removeView$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

