/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core;

import dev.jsinco.recipes.core.RecipeWriter;
import dev.jsinco.recipes.core.flaws.Flaw;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0015"}, d2={"Ldev/jsinco/recipes/core/RecipeView;", "", "recipeIdentifier", "", "flaws", "", "Ldev/jsinco/recipes/core/flaws/Flaw;", "invertedReveals", "", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getRecipeIdentifier", "()Ljava/lang/String;", "getFlaws", "()Ljava/util/List;", "getInvertedReveals", "translation", "Lnet/kyori/adventure/text/Component;", "brewDisplayName", "Companion", "Recipes"})
public final class RecipeView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recipeIdentifier;
    @NotNull
    private final List<Flaw> flaws;
    @NotNull
    private final List<Set<Integer>> invertedReveals;

    public RecipeView(@NotNull String recipeIdentifier, @NotNull List<Flaw> flaws, @NotNull List<? extends Set<Integer>> invertedReveals) {
        Intrinsics.checkNotNullParameter(recipeIdentifier, "recipeIdentifier");
        Intrinsics.checkNotNullParameter(flaws, "flaws");
        Intrinsics.checkNotNullParameter(invertedReveals, "invertedReveals");
        this.recipeIdentifier = recipeIdentifier;
        this.flaws = flaws;
        this.invertedReveals = invertedReveals;
    }

    @NotNull
    public final String getRecipeIdentifier() {
        return this.recipeIdentifier;
    }

    @NotNull
    public final List<Flaw> getFlaws() {
        return this.flaws;
    }

    @NotNull
    public final List<Set<Integer>> getInvertedReveals() {
        return this.invertedReveals;
    }

    @NotNull
    public final Component translation(@NotNull Component brewDisplayName) {
        Intrinsics.checkNotNullParameter(brewDisplayName, "brewDisplayName");
        double fragmentation = RecipeWriter.INSTANCE.estimateFragmentation(this);
        String translationName = fragmentation == 0.0 ? "recipes.display.recipe.name.complete" : (fragmentation < 25.0 ? "recipes.display.recipe.name.slightly-fragmented" : (fragmentation < 50.0 ? "recipes.display.recipe.name.moderately-fragmented" : (fragmentation < 75.0 ? "recipes.display.recipe.name.heavily-fragmented" : "recipes.display.recipe.name.severely-fragmented")));
        ComponentLike[] componentLikeArray = new ComponentLike[]{Argument.component((String)"name", (ComponentLike)((ComponentLike)brewDisplayName))};
        TranslatableComponent translatableComponent = Component.translatable((String)translationName, (ComponentLike[])componentLikeArray);
        Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
        return (Component)translatableComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Ldev/jsinco/recipes/core/RecipeView$Companion;", "", "<init>", "()V", "of", "Ldev/jsinco/recipes/core/RecipeView;", "identifier", "", "flaws", "", "Ldev/jsinco/recipes/core/flaws/Flaw;", "Recipes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecipeView of(@NotNull String identifier, @NotNull List<Flaw> flaws) {
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            Intrinsics.checkNotNullParameter(flaws, "flaws");
            return new RecipeView(identifier, flaws, CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

