/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.core;

import com.google.common.collect.ImmutableList;
import dev.jsinco.recipes.core.RecipeView;
import dev.jsinco.recipes.core.flaws.creation.RecipeViewCreator;
import dev.jsinco.recipes.core.process.Ingredient;
import dev.jsinco.recipes.core.process.Step;
import dev.jsinco.recipes.core.process.steps.AgeStep;
import dev.jsinco.recipes.core.process.steps.CookStep;
import dev.jsinco.recipes.core.process.steps.DistillStep;
import dev.jsinco.recipes.core.process.steps.MixStep;
import dev.jsinco.recipes.util.RecipeUtil;
import dev.jsinco.recipes.util.TranslationUtil;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Ldev/jsinco/recipes/core/BreweryRecipe;", "", "identifier", "", "steps", "", "Ldev/jsinco/recipes/core/process/Step;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getIdentifier", "()Ljava/lang/String;", "getSteps", "()Ljava/util/List;", "lootItem", "Lorg/bukkit/inventory/ItemStack;", "recipeViewCreatorType", "Ldev/jsinco/recipes/core/flaws/creation/RecipeViewCreator$Type;", "generateCompletedView", "Ldev/jsinco/recipes/core/RecipeView;", "generate", "expectedFlawLevel", "", "flawViewType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "Recipes"})
@SourceDebugExtension(value={"SMAP\nBreweryRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreweryRecipe.kt\ndev/jsinco/recipes/core/BreweryRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1563#2:101\n1634#2,3:102\n1563#2:105\n1634#2,3:106\n1563#2:109\n1634#2,3:110\n*S KotlinDebug\n*F\n+ 1 BreweryRecipe.kt\ndev/jsinco/recipes/core/BreweryRecipe\n*L\n38#1:101\n38#1:102,3\n39#1:105\n39#1:106,3\n40#1:109\n40#1:110,3\n*E\n"})
public final class BreweryRecipe {
    @NotNull
    private final String identifier;
    @NotNull
    private final List<Step> steps;

    public BreweryRecipe(@NotNull String identifier, @NotNull List<? extends Step> steps) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(steps, "steps");
        this.identifier = identifier;
        this.steps = steps;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final List<Step> getSteps() {
        return this.steps;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack lootItem() {
        void $this$mapTo$iv$iv;
        TranslatableComponent it;
        Collection<TranslatableComponent> collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        ItemStack itemStack = new ItemStack(Material.PAPER);
        Component component = ((TranslatableComponent)Component.translatable((String)"recipes.loot.recipe.completed").colorIfAbsent((TextColor)NamedTextColor.WHITE)).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        Intrinsics.checkNotNullExpressionValue(component, "decorationIfAbsent(...)");
        itemStack.setData(DataComponentTypes.CUSTOM_NAME, (Object)TranslationUtil.INSTANCE.render(component));
        Iterable iterable = CollectionsKt.listOf(Component.translatable((String)"recipes.loot.right.click.to.discover"));
        DataComponentType.Valued valued = DataComponentTypes.LORE;
        ItemStack itemStack2 = itemStack;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            TranslatableComponent translatableComponent = (TranslatableComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((TranslatableComponent)it.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (TranslatableComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((TranslatableComponent)it.colorIfAbsent((TextColor)NamedTextColor.GRAY));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        TranslationUtil translationUtil = TranslationUtil.INSTANCE;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Component bl = (Component)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((TranslatableComponent)translationUtil.render((Component)p0));
        }
        collection = (List)destination$iv$iv2;
        itemStack2.setData(valued, (Object)ItemLore.lore(collection));
        itemStack.editPersistentDataContainer(arg_0 -> BreweryRecipe.lootItem$lambda$2(this, arg_0));
        return itemStack;
    }

    @NotNull
    public final ItemStack lootItem(@NotNull RecipeViewCreator.Type recipeViewCreatorType) {
        Intrinsics.checkNotNullParameter((Object)recipeViewCreatorType, "recipeViewCreatorType");
        ItemStack output = this.lootItem();
        output.editPersistentDataContainer(arg_0 -> BreweryRecipe.lootItem$lambda$3(recipeViewCreatorType, arg_0));
        Component component = ((TranslatableComponent)Component.translatable((String)recipeViewCreatorType.getLootTranslationKey()).colorIfAbsent((TextColor)NamedTextColor.WHITE)).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        Intrinsics.checkNotNullExpressionValue(component, "decorationIfAbsent(...)");
        output.setData(DataComponentTypes.CUSTOM_NAME, (Object)TranslationUtil.INSTANCE.render(component));
        return output;
    }

    @NotNull
    public final RecipeView generateCompletedView() {
        return RecipeView.Companion.of(this.identifier, CollectionsKt.emptyList());
    }

    @NotNull
    public final RecipeView generate(double expectedFlawLevel) {
        RecipeViewCreator.Type collection = (RecipeViewCreator.Type)((Object)CollectionsKt.random((Collection)RecipeViewCreator.Type.getEntries(), Random.Default));
        return this.generate(expectedFlawLevel, collection);
    }

    @NotNull
    public final RecipeView generate(double expectedFlawLevel, @NotNull RecipeViewCreator.Type flawViewType) {
        Intrinsics.checkNotNullParameter((Object)flawViewType, "flawViewType");
        return flawViewType.getRecipeViewCreator().create(this, expectedFlawLevel);
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @NotNull
    public final List<Step> component2() {
        return this.steps;
    }

    @NotNull
    public final BreweryRecipe copy(@NotNull String identifier, @NotNull List<? extends Step> steps) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(steps, "steps");
        return new BreweryRecipe(identifier, steps);
    }

    public static /* synthetic */ BreweryRecipe copy$default(BreweryRecipe breweryRecipe, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = breweryRecipe.identifier;
        }
        if ((n & 2) != 0) {
            list = breweryRecipe.steps;
        }
        return breweryRecipe.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "BreweryRecipe(identifier=" + this.identifier + ", steps=" + this.steps + ")";
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + ((Object)this.steps).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BreweryRecipe)) {
            return false;
        }
        BreweryRecipe breweryRecipe = (BreweryRecipe)other;
        if (!Intrinsics.areEqual(this.identifier, breweryRecipe.identifier)) {
            return false;
        }
        return Intrinsics.areEqual(this.steps, breweryRecipe.steps);
    }

    private static final void lootItem$lambda$2(BreweryRecipe this$0, PersistentDataContainer it) {
        it.set(RecipeUtil.INSTANCE.getRECIPE_KEY(), PersistentDataType.STRING, (Object)this$0.identifier);
    }

    private static final void lootItem$lambda$3(RecipeViewCreator.Type $recipeViewCreatorType, PersistentDataContainer it) {
        NamespacedKey namespacedKey = RecipeUtil.INSTANCE.getFLAW_KEY();
        String string = $recipeViewCreatorType.name();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        it.set(namespacedKey, PersistentDataType.STRING, (Object)string2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ*\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/jsinco/recipes/core/BreweryRecipe$Builder;", "", "identifier", "", "<init>", "(Ljava/lang/String;)V", "stepsBuilder", "Lcom/google/common/collect/ImmutableList$Builder;", "Ldev/jsinco/recipes/core/process/Step;", "mix", "ticks", "", "cauldronType", "ingredients", "", "Ldev/jsinco/recipes/core/process/Ingredient;", "", "cook", "distill", "count", "age", "barrelType", "build", "Ldev/jsinco/recipes/core/BreweryRecipe;", "Recipes"})
    @SourceDebugExtension(value={"SMAP\nBreweryRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreweryRecipe.kt\ndev/jsinco/recipes/core/BreweryRecipe$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String identifier;
        @NotNull
        private final ImmutableList.Builder<Step> stepsBuilder;

        public Builder(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            this.identifier = identifier;
            this.stepsBuilder = new ImmutableList.Builder();
        }

        @NotNull
        public final Builder mix(long ticks, @NotNull String cauldronType, @NotNull Map<Ingredient, Integer> ingredients) {
            Builder builder;
            Intrinsics.checkNotNullParameter(cauldronType, "cauldronType");
            Intrinsics.checkNotNullParameter(ingredients, "ingredients");
            Builder $this$mix_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$mix_u24lambda_u240.stepsBuilder.add((Object)new MixStep(ticks, MixStep.CauldronType.Companion.fromString(cauldronType), ingredients));
            return builder;
        }

        @NotNull
        public final Builder cook(long ticks, @NotNull String cauldronType, @NotNull Map<Ingredient, Integer> ingredients) {
            Builder builder;
            Intrinsics.checkNotNullParameter(cauldronType, "cauldronType");
            Intrinsics.checkNotNullParameter(ingredients, "ingredients");
            Builder $this$cook_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$cook_u24lambda_u240.stepsBuilder.add((Object)new CookStep(ticks, CookStep.CauldronType.Companion.fromString(cauldronType), ingredients));
            return builder;
        }

        @NotNull
        public final Builder distill(long count) {
            Builder builder;
            Builder $this$distill_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$distill_u24lambda_u240.stepsBuilder.add((Object)new DistillStep(count));
            return builder;
        }

        @NotNull
        public final Builder age(long ticks, @NotNull String barrelType) {
            Builder builder;
            Intrinsics.checkNotNullParameter(barrelType, "barrelType");
            Builder $this$age_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$age_u24lambda_u240.stepsBuilder.add((Object)new AgeStep(ticks, AgeStep.BarrelType.Companion.fromString(barrelType)));
            return builder;
        }

        @NotNull
        public final BreweryRecipe build() {
            ImmutableList immutableList = this.stepsBuilder.build();
            Intrinsics.checkNotNullExpressionValue(immutableList, "build(...)");
            return new BreweryRecipe(this.identifier, (List)immutableList);
        }
    }
}

