/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.configuration.serialize;

import dev.jsinco.recipes.configuration.spawning.ConditionsDefinition;
import dev.jsinco.recipes.configuration.spawning.SpawnDefinition;
import dev.jsinco.recipes.configuration.spawning.triggers.TriggersDefinition;
import dev.jsinco.recipes.core.flaws.creation.RecipeViewCreator;
import eu.okaeri.configs.schema.GenericsDeclaration;
import eu.okaeri.configs.serdes.DeserializationData;
import eu.okaeri.configs.serdes.ObjectSerializer;
import eu.okaeri.configs.serdes.SerializationData;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Ldev/jsinco/recipes/configuration/serialize/SpawnDefinitionSerializer;", "Leu/okaeri/configs/serdes/ObjectSerializer;", "Ldev/jsinco/recipes/configuration/spawning/SpawnDefinition;", "<init>", "()V", "supports", "", "type", "Ljava/lang/Class;", "serialize", "", "object", "data", "Leu/okaeri/configs/serdes/SerializationData;", "generics", "Leu/okaeri/configs/schema/GenericsDeclaration;", "deserialize", "Leu/okaeri/configs/serdes/DeserializationData;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nSpawnDefinitionSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnDefinitionSerializer.kt\ndev/jsinco/recipes/configuration/serialize/SpawnDefinitionSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class SpawnDefinitionSerializer
implements ObjectSerializer<SpawnDefinition> {
    @NotNull
    public static final SpawnDefinitionSerializer INSTANCE = new SpawnDefinitionSerializer();

    private SpawnDefinitionSerializer() {
    }

    @Override
    public boolean supports(@NotNull Class<? super SpawnDefinition> type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return SpawnDefinition.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NotNull SpawnDefinition object, @NotNull SerializationData data, @NotNull GenericsDeclaration generics) {
        block8: {
            int it;
            Intrinsics.checkNotNullParameter(object, "object");
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(generics, "generics");
            Boolean bl = object.getEnabled();
            if (bl != null) {
                it = bl.booleanValue();
                boolean bl2 = false;
                data.add("enabled", it != 0);
            }
            Integer n = object.getAttempts();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl3 = false;
                data.add("attempts", it);
            }
            Double d = object.getChance();
            if (d != null) {
                double it2 = ((Number)d).doubleValue();
                boolean bl4 = false;
                data.add("chance", it2);
            }
            Collection collection = object.getRecipeWhitelist();
            if (!(collection == null || collection.isEmpty())) {
                data.add("recipe-whitelist", object.getRecipeWhitelist());
            }
            if (!((collection = (Collection)object.getRecipeBlacklist()) == null || collection.isEmpty())) {
                data.add("recipe-blacklist", object.getRecipeBlacklist());
            }
            data.add("flawless", object.getFlawless());
            List<RecipeViewCreator.Type> list = object.getFlaws();
            if (list != null) {
                List<RecipeViewCreator.Type> it3 = list;
                boolean bl5 = false;
                data.add("flaws", it3);
            }
            ConditionsDefinition conditionsDefinition = object.getConditions();
            if (conditionsDefinition != null) {
                ConditionsDefinition it4 = conditionsDefinition;
                boolean bl6 = false;
                data.add("conditions", it4);
            }
            ConditionsDefinition conditionsDefinition2 = object.getConditionBlacklist();
            if (conditionsDefinition2 != null) {
                ConditionsDefinition it5 = conditionsDefinition2;
                boolean bl7 = false;
                data.add("condition-blacklist", it5);
            }
            TriggersDefinition triggersDefinition = object.getTriggers();
            if (triggersDefinition == null) break block8;
            TriggersDefinition it6 = triggersDefinition;
            boolean bl8 = false;
            data.add("triggers", it6);
        }
    }

    @Override
    @Nullable
    public SpawnDefinition deserialize(@NotNull DeserializationData data, @NotNull GenericsDeclaration generics) {
        List<String> list;
        List<String> whitelist;
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(generics, "generics");
        Boolean bl = data.get("enabled", Boolean.TYPE);
        boolean enabled = bl != null ? bl : true;
        Integer attempts = data.get("attempts", Integer.class);
        Double chance = data.get("chance", Double.class);
        List<String> list2 = data.getAsList("recipe-whitelist", String.class);
        if (list2 == null) {
            list2 = whitelist = CollectionsKt.emptyList();
        }
        if ((list = data.getAsList("recipe-blacklist", String.class)) == null) {
            list = CollectionsKt.emptyList();
        }
        List<String> blacklist = list;
        Boolean bl2 = data.get("flawless", Boolean.TYPE);
        boolean flawless = bl2 != null ? bl2 : false;
        List<RecipeViewCreator.Type> list3 = data.getAsList("flaws", RecipeViewCreator.Type.class);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List<RecipeViewCreator.Type> flaws = list3;
        ConditionsDefinition conditions = data.get("conditions", ConditionsDefinition.class);
        ConditionsDefinition conditionsBlacklist = data.get("condition-blacklist", ConditionsDefinition.class);
        TriggersDefinition triggers = data.get("triggers", TriggersDefinition.class);
        return new SpawnDefinition(enabled, attempts, chance, flaws, flawless, blacklist, whitelist, triggers, conditions, conditionsBlacklist);
    }
}

