/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.configuration.serialize;

import dev.jsinco.recipes.util.Logger;
import eu.okaeri.configs.schema.GenericsDeclaration;
import eu.okaeri.configs.serdes.DeserializationData;
import eu.okaeri.configs.serdes.ObjectSerializer;
import eu.okaeri.configs.serdes.SerializationData;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Keyed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007H\u0016J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/jsinco/recipes/configuration/serialize/KeyedSerializer;", "T", "Lorg/bukkit/Keyed;", "Leu/okaeri/configs/serdes/ObjectSerializer;", "registryKey", "Lio/papermc/paper/registry/RegistryKey;", "tClass", "Ljava/lang/Class;", "<init>", "(Lio/papermc/paper/registry/RegistryKey;Ljava/lang/Class;)V", "supports", "", "type", "serialize", "", "object", "data", "Leu/okaeri/configs/serdes/SerializationData;", "generics", "Leu/okaeri/configs/schema/GenericsDeclaration;", "(Lorg/bukkit/Keyed;Leu/okaeri/configs/serdes/SerializationData;Leu/okaeri/configs/schema/GenericsDeclaration;)V", "deserialize", "Leu/okaeri/configs/serdes/DeserializationData;", "(Leu/okaeri/configs/serdes/DeserializationData;Leu/okaeri/configs/schema/GenericsDeclaration;)Lorg/bukkit/Keyed;", "Recipes"})
public final class KeyedSerializer<T extends Keyed>
implements ObjectSerializer<T> {
    @NotNull
    private final RegistryKey<T> registryKey;
    @NotNull
    private final Class<T> tClass;

    public KeyedSerializer(@NotNull RegistryKey<T> registryKey, @NotNull Class<T> tClass) {
        Intrinsics.checkNotNullParameter(registryKey, "registryKey");
        Intrinsics.checkNotNullParameter(tClass, "tClass");
        this.registryKey = registryKey;
        this.tClass = tClass;
    }

    @Override
    public boolean supports(@NotNull Class<? super T> type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return this.tClass.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NotNull T object, @NotNull SerializationData data, @NotNull GenericsDeclaration generics) {
        Intrinsics.checkNotNullParameter(object, "object");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(generics, "generics");
        data.setValue(object.getKey());
    }

    @Override
    @Nullable
    public T deserialize(@NotNull DeserializationData data, @NotNull GenericsDeclaration generics) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(generics, "generics");
        Key key = data.getValue(Key.class);
        if (key == null) {
            KeyedSerializer it = this;
            boolean bl = false;
            Logger.INSTANCE.logErr("Invalid key: " + data.getValueRaw());
            return null;
        }
        Key key2 = key;
        Keyed keyed = RegistryAccess.registryAccess().getRegistry(this.registryKey).get(key2);
        if (keyed == null) {
            KeyedSerializer it = this;
            boolean bl = false;
            Logger.INSTANCE.logErr("Unknown key: " + key2);
            keyed = null;
        }
        return (T)keyed;
    }
}

