/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.configuration.serialize;

import dev.jsinco.recipes.configuration.ConfigItem;
import dev.jsinco.recipes.configuration.Lore;
import eu.okaeri.configs.schema.GenericsDeclaration;
import eu.okaeri.configs.serdes.DeserializationData;
import eu.okaeri.configs.serdes.ObjectSerializer;
import eu.okaeri.configs.serdes.SerializationData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Ldev/jsinco/recipes/configuration/serialize/ConfigItemSerializer;", "Leu/okaeri/configs/serdes/ObjectSerializer;", "Ldev/jsinco/recipes/configuration/ConfigItem;", "<init>", "()V", "supports", "", "type", "Ljava/lang/Class;", "serialize", "", "object", "data", "Leu/okaeri/configs/serdes/SerializationData;", "generics", "Leu/okaeri/configs/schema/GenericsDeclaration;", "deserialize", "Leu/okaeri/configs/serdes/DeserializationData;", "Recipes"})
@SourceDebugExtension(value={"SMAP\nConfigItemSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigItemSerializer.kt\ndev/jsinco/recipes/configuration/serialize/ConfigItemSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class ConfigItemSerializer
implements ObjectSerializer<ConfigItem> {
    @NotNull
    public static final ConfigItemSerializer INSTANCE = new ConfigItemSerializer();

    private ConfigItemSerializer() {
    }

    @Override
    public boolean supports(@NotNull Class<? super ConfigItem> type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return ConfigItem.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NotNull ConfigItem object, @NotNull SerializationData data, @NotNull GenericsDeclaration generics) {
        Object it;
        Intrinsics.checkNotNullParameter(object, "object");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(generics, "generics");
        Material material = object.getMaterial();
        if (material != null) {
            it = material;
            boolean bl = false;
            data.add("material", it);
        }
        Component component = object.getName();
        if (component != null) {
            it = component;
            boolean bl = false;
            data.add("name", it);
        }
        Lore lore = object.getLore();
        if (lore != null) {
            it = lore;
            boolean bl = false;
            data.add("lore", it);
        }
        if (object.getGlint()) {
            data.add("glint", true);
        }
        Integer n = object.getCustomModelData();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            data.add("custom-model-data", it2);
        }
        Key key = object.getItemModel();
        if (key != null) {
            Key it3 = key;
            boolean bl = false;
            data.add("item-model", it3);
        }
        if (object.getNoText()) {
            data.add("no-text", true);
        }
    }

    @Override
    @Nullable
    public ConfigItem deserialize(@NotNull DeserializationData data, @NotNull GenericsDeclaration generics) {
        ConfigItem.Builder builder;
        block6: {
            Object it;
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(generics, "generics");
            Material material = data.get("material", Material.class);
            if (material == null) {
                return null;
            }
            Material material2 = material;
            builder = new ConfigItem.Builder();
            builder.material(material2);
            Component component = data.get("name", Component.class);
            if (component != null) {
                it = component;
                boolean bl = false;
                builder.name((Component)it);
            }
            List<Component> list = data.getAsList("lore", Component.class);
            if (list != null) {
                it = list;
                boolean bl = false;
                builder.lore((List<? extends Component>)it);
            }
            Boolean bl = data.get("glint", Boolean.TYPE);
            if (bl != null) {
                boolean it2 = bl;
                boolean bl2 = false;
                builder.glint(it2);
            }
            Integer n = data.get("custom-model-data", Integer.TYPE);
            if (n != null) {
                int it3 = ((Number)n).intValue();
                boolean bl3 = false;
                builder.customModelData(it3);
            }
            Key key = data.get("item-model", Key.class);
            if (key != null) {
                Key it4 = key;
                boolean bl4 = false;
                builder.itemModel(it4);
            }
            Boolean bl5 = data.get("no-text", Boolean.TYPE);
            if (bl5 == null) break block6;
            boolean it5 = bl5;
            boolean bl6 = false;
            builder.noText(it5);
        }
        return builder.build();
    }
}

