/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/jsinco/recipes/configuration/RecipesTranslator;", "Lnet/kyori/adventure/text/minimessage/translation/MiniMessageTranslator;", "localeDirectory", "Ljava/io/File;", "lang", "Ljava/util/Locale;", "<init>", "(Ljava/io/File;Ljava/util/Locale;)V", "translations", "", "Ljava/util/Properties;", "reload", "", "syncLangFiles", "mergeAndStoreProperties", "internalFile", "Ljava/nio/file/Path;", "storeWithoutComments", "props", "writer", "Ljava/io/Writer;", "loadLangFiles", "name", "Lnet/kyori/adventure/key/Key;", "getMiniMessageString", "", "key", "locale", "Recipes"})
@SourceDebugExtension(value={"SMAP\nRecipesTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipesTranslator.kt\ndev/jsinco/recipes/configuration/RecipesTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class RecipesTranslator
extends MiniMessageTranslator {
    @NotNull
    private final File localeDirectory;
    @NotNull
    private Locale lang;
    @NotNull
    private Map<Locale, ? extends Properties> translations;

    public RecipesTranslator(@NotNull File localeDirectory, @NotNull Locale lang) {
        Intrinsics.checkNotNullParameter(localeDirectory, "localeDirectory");
        Intrinsics.checkNotNullParameter(lang, "lang");
        this.localeDirectory = localeDirectory;
        this.lang = lang;
        this.syncLangFiles();
        this.translations = this.loadLangFiles();
    }

    public final void reload() {
        this.syncLangFiles();
        this.translations = this.loadLangFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void syncLangFiles() {
        if (!(this.localeDirectory.exists() || this.localeDirectory.mkdirs())) {
            boolean $i$a$-check-RecipesTranslator$syncLangFiles$22 = false;
            String $i$a$-check-RecipesTranslator$syncLangFiles$22 = "Failed to create locale directory at " + this.localeDirectory.getAbsolutePath();
            throw new IllegalStateException($i$a$-check-RecipesTranslator$syncLangFiles$22.toString());
        }
        try {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("locale");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Closeable closeable = Intrinsics.areEqual("jar", url.getProtocol()) ? FileSystems.newFileSystem(url.toURI(), (Map)new LinkedHashMap()) : null;
                Throwable throwable = null;
                try {
                    FileSystem fs = (FileSystem)closeable;
                    boolean bl = false;
                    Path internalLocaleDir = Paths.get(url.toURI());
                    Closeable closeable2 = Files.newDirectoryStream(internalLocaleDir, "*.lang.properties");
                    Throwable throwable2 = null;
                    try {
                        Iterator iterator2;
                        DirectoryStream stream = (DirectoryStream)closeable2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue(stream.iterator(), "iterator(...)");
                        while (iterator2.hasNext()) {
                            Path path = (Path)iterator2.next();
                            Intrinsics.checkNotNull(path);
                            this.mergeAndStoreProperties(path);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to sync language files", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to sync language files", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeAndStoreProperties(Path internalFile) throws IOException {
        Iterator<String> iterator2;
        String fileName = ((Object)internalFile.getFileName()).toString();
        File externalFile = new File(this.localeDirectory, fileName);
        Properties internalProps = new Properties();
        Closeable closeable = Files.newBufferedReader(internalFile, StandardCharsets.UTF_8);
        Object object = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            internalProps.load(reader);
            iterator2 = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        Properties merged = new Properties();
        if (externalFile.exists()) {
            Properties externalProps = new Properties();
            iterator2 = new InputStreamReader((InputStream)new FileInputStream(externalFile), StandardCharsets.UTF_8);
            bl = null;
            try {
                Object reader = (InputStreamReader)((Object)iterator2);
                boolean bl = false;
                externalProps.load((Reader)reader);
                reader = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                bl = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)iterator2), bl);
            }
            merged.putAll((Map<?, ?>)externalProps);
            for (String key : internalProps.stringPropertyNames()) {
                merged.putIfAbsent(key, internalProps.getProperty(key));
            }
        } else {
            merged.putAll((Map<?, ?>)internalProps);
            if (!externalFile.createNewFile()) {
                throw new IOException("Could not create file: " + externalFile);
            }
        }
        object = new OutputStreamWriter((OutputStream)new FileOutputStream(externalFile), StandardCharsets.UTF_8);
        iterator2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            this.storeWithoutComments(merged, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            iterator2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)((Object)iterator2));
        }
    }

    private final void storeWithoutComments(Properties props, Writer writer) throws IOException {
        List keys2 = new ArrayList(props.stringPropertyNames());
        CollectionsKt.sort(keys2);
        for (String key : keys2) {
            writer.write(key + "=" + props.getProperty(key) + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Locale, Properties> loadLangFiles() {
        if (!this.localeDirectory.isDirectory()) {
            boolean $i$a$-require-RecipesTranslator$loadLangFiles$22 = false;
            String $i$a$-require-RecipesTranslator$loadLangFiles$22 = "Locale directory is not a directory!";
            throw new IllegalArgumentException($i$a$-require-RecipesTranslator$loadLangFiles$22.toString());
        }
        ImmutableMap.Builder translationsBuilder = new ImmutableMap.Builder();
        File[] fileArray = this.localeDirectory.listFiles(RecipesTranslator::loadLangFiles$lambda$1);
        Intrinsics.checkNotNullExpressionValue(fileArray, "listFiles(...)");
        for (File translationFile : fileArray) {
            try {
                Closeable closeable = new FileInputStream(translationFile);
                Throwable throwable = null;
                try {
                    FileInputStream inputStream = (FileInputStream)closeable;
                    boolean bl = false;
                    Properties translation = new Properties();
                    translation.load(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                    String string = translationFile.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    CharSequence charSequence = string;
                    Regex regex = new Regex(".lang.properties$");
                    String string2 = "";
                    Locale locale = Locale.forLanguageTag(regex.replace(charSequence, string2));
                    if (locale != null) {
                        translationsBuilder.put((Object)locale, (Object)translation);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ImmutableMap output = translationsBuilder.build();
        Preconditions.checkArgument((boolean)output.containsKey((Object)this.lang), (String)("Unknown translation: " + this.lang), (Object[])new Object[0]);
        Intrinsics.checkNotNull(output);
        return (Map)output;
    }

    @NotNull
    public Key name() {
        Key key = Key.key((String)"recipes:global_translator");
        Intrinsics.checkNotNullExpressionValue(key, "key(...)");
        return key;
    }

    @Nullable
    public String getMiniMessageString(@NotNull String key, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(locale, "locale");
        Properties translation = this.translations.get(this.lang);
        Preconditions.checkState((translation != null ? 1 : 0) != 0, (String)"Should have found a translation!", (Object[])new Object[0]);
        Properties properties = translation;
        Intrinsics.checkNotNull(properties);
        return properties.getProperty(key);
    }

    private static final boolean loadLangFiles$lambda$1(File file) {
        Object object = file;
        return object != null && (object = ((File)object).getName()) != null ? StringsKt.endsWith$default((String)object, ".lang.properties", false, 2, null) : false;
    }
}

