/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.recipes;

import com.dre.brewery.recipe.BRecipe;
import dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi;
import dev.jsinco.recipes.Recipes;
import dev.jsinco.recipes.configuration.GuiConfig;
import dev.jsinco.recipes.configuration.RecipesConfig;
import dev.jsinco.recipes.configuration.RecipesTranslator;
import dev.jsinco.recipes.configuration.SpawnConfig;
import dev.jsinco.recipes.configuration.serialize.ComponentSerializer;
import dev.jsinco.recipes.configuration.serialize.ConditionsDefinitionSerializer;
import dev.jsinco.recipes.configuration.serialize.ConfigItemCollectionSerializer;
import dev.jsinco.recipes.configuration.serialize.ConfigItemSerializer;
import dev.jsinco.recipes.configuration.serialize.KeySerializer;
import dev.jsinco.recipes.configuration.serialize.KeyedSerializer;
import dev.jsinco.recipes.configuration.serialize.LocaleSerializer;
import dev.jsinco.recipes.configuration.serialize.LoreSerializer;
import dev.jsinco.recipes.configuration.serialize.SerdesPackBuilder;
import dev.jsinco.recipes.configuration.serialize.SpawnDefinitionSerializer;
import dev.jsinco.recipes.configuration.serialize.TriggersDefinitionSerializer;
import dev.jsinco.recipes.core.BreweryRecipe;
import dev.jsinco.recipes.core.RecipeViewManager;
import dev.jsinco.recipes.data.DataManager;
import dev.jsinco.recipes.data.StorageImpl;
import dev.jsinco.recipes.gui.integration.BreweryXGuiInterface;
import dev.jsinco.recipes.gui.integration.GuiIntegration;
import dev.jsinco.recipes.gui.integration.TbpGuiInterface;
import dev.jsinco.recipes.listeners.GuiEventListener;
import dev.jsinco.recipes.listeners.RecipeListener;
import dev.jsinco.recipes.listeners.RecipeSpawningListener;
import dev.jsinco.recipes.util.BookUtil;
import dev.jsinco.recipes.util.BreweryXRecipeConverter;
import dev.jsinco.recipes.util.ClassUtil;
import dev.jsinco.recipes.util.TBPRecipeConverter;
import eu.okaeri.configs.ConfigManager;
import eu.okaeri.configs.OkaeriConfig;
import eu.okaeri.configs.serdes.ObjectSerializer;
import eu.okaeri.configs.serdes.OkaeriSerdesPack;
import eu.okaeri.configs.yaml.bukkit.YamlBukkitConfigurer;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryKey;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0006\u0010\u001a\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Ldev/jsinco/recipes/Recipes;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "storageImpl", "Ldev/jsinco/recipes/data/StorageImpl;", "getStorageImpl", "()Ldev/jsinco/recipes/data/StorageImpl;", "setStorageImpl", "(Ldev/jsinco/recipes/data/StorageImpl;)V", "onEnable", "", "loadRecipeProvider", "", "Ldev/jsinco/recipes/core/BreweryRecipe;", "loadGuiIntegration", "Ldev/jsinco/recipes/gui/integration/GuiIntegration;", "readConfig", "Ldev/jsinco/recipes/configuration/RecipesConfig;", "readGuiConfig", "Ldev/jsinco/recipes/configuration/GuiConfig;", "configSerializers", "Ldev/jsinco/recipes/configuration/serialize/SerdesPackBuilder;", "readSpawnConfig", "Ldev/jsinco/recipes/configuration/SpawnConfig;", "onLoad", "reload", "Companion", "Recipes"})
@SourceDebugExtension(value={"SMAP\nRecipes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Recipes.kt\ndev/jsinco/recipes/Recipes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1563#2:181\n1634#2,3:182\n1563#2:185\n1634#2,3:186\n*S KotlinDebug\n*F\n+ 1 Recipes.kt\ndev/jsinco/recipes/Recipes\n*L\n107#1:181\n107#1:182,3\n111#1:185\n111#1:186,3\n*E\n"})
public final class Recipes
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public StorageImpl storageImpl;
    public static Recipes instance;
    public static RecipesConfig recipesConfig;
    public static GuiConfig guiConfig;
    public static SpawnConfig spawnConfig;
    public static RecipeViewManager recipeViewManager;
    private static Map<String, BreweryRecipe> recipeMap;

    @NotNull
    public final StorageImpl getStorageImpl() {
        StorageImpl storageImpl = this.storageImpl;
        if (storageImpl != null) {
            return storageImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException("storageImpl");
        return null;
    }

    public final void setStorageImpl(@NotNull StorageImpl storageImpl) {
        Intrinsics.checkNotNullParameter(storageImpl, "<set-?>");
        this.storageImpl = storageImpl;
    }

    public void onEnable() {
        Companion.setRecipesConfig(this.readConfig());
        Companion.setGuiConfig(this.readGuiConfig());
        Companion.setSpawnConfig(this.readSpawnConfig());
        File file = this.getDataFolder();
        Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
        this.setStorageImpl(new DataManager(file).getStorageImpl());
        Companion.setRecipeViewManager(new RecipeViewManager(this.getStorageImpl()));
        RecipesTranslator translator = new RecipesTranslator(new File(this.getDataFolder(), "locale"), Companion.getRecipesConfig().getLanguage());
        translator.reload();
        GlobalTranslator.translator().addSource((Translator)translator);
        GuiIntegration guiIntegration = this.loadGuiIntegration();
        Bukkit.getPluginManager().registerEvents((Listener)new GuiEventListener(this, guiIntegration), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new RecipeSpawningListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new RecipeListener(guiIntegration), (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, (LifecycleEventHandler)onEnable.1.INSTANCE);
        ShapelessRecipe book = new ShapelessRecipe(Companion.key("recipe_book"), BookUtil.INSTANCE.createBook());
        book.addIngredient(Material.PAPER);
        book.addIngredient(Material.BOOK);
        Bukkit.addRecipe((Recipe)((Recipe)book));
    }

    /*
     * WARNING - void declaration
     */
    private final List<BreweryRecipe> loadRecipeProvider() {
        if (ClassUtil.INSTANCE.exists("dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi")) {
            void $this$mapTo$iv$iv;
            if (!Bukkit.getServicesManager().isProvidedFor(TheBrewingProjectApi.class)) {
                return null;
            }
            RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(TheBrewingProjectApi.class);
            if (registeredServiceProvider == null || (registeredServiceProvider = (TheBrewingProjectApi)registeredServiceProvider.getProvider()) == null) {
                return null;
            }
            RegisteredServiceProvider provider = registeredServiceProvider;
            Collection collection = provider.getRecipeRegistry().getRecipes();
            Intrinsics.checkNotNullExpressionValue(collection, "getRecipes(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                dev.jsinco.brewery.api.recipe.Recipe recipe = (dev.jsinco.brewery.api.recipe.Recipe)item$iv$iv2;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection2.add(TBPRecipeConverter.INSTANCE.convert((dev.jsinco.brewery.api.recipe.Recipe<ItemStack>)it));
            }
            return (List)destination$iv$iv;
        }
        if (ClassUtil.INSTANCE.exists("com.dre.brewery.recipe.BRecipe")) {
            void $this$mapTo$iv$iv;
            List list = BRecipe.getRecipes();
            Intrinsics.checkNotNullExpressionValue(list, "getRecipes(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BRecipe item$iv$iv2 = (BRecipe)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection.add(BreweryXRecipeConverter.INSTANCE.convert((BRecipe)it));
            }
            return (List)destination$iv$iv;
        }
        throw new IllegalStateException("Expected either BreweryX to be available or TBP");
    }

    private final GuiIntegration loadGuiIntegration() {
        if (ClassUtil.INSTANCE.exists("dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi")) {
            return TbpGuiInterface.INSTANCE;
        }
        if (ClassUtil.INSTANCE.exists("com.dre.brewery.recipe.BRecipe")) {
            return BreweryXGuiInterface.INSTANCE;
        }
        throw new IllegalStateException("Expected either BreweryX to be available or TBP");
    }

    private final RecipesConfig readConfig() {
        RecipesConfig recipesConfig = ConfigManager.create(RecipesConfig.class, arg_0 -> Recipes.readConfig$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(recipesConfig, "create(...)");
        return recipesConfig;
    }

    private final GuiConfig readGuiConfig() {
        GuiConfig guiConfig = ConfigManager.create(GuiConfig.class, arg_0 -> Recipes.readGuiConfig$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(guiConfig, "create(...)");
        return guiConfig;
    }

    private final SerdesPackBuilder configSerializers() {
        SerdesPackBuilder serdesPackBuilder = new SerdesPackBuilder().add(ComponentSerializer.INSTANCE).add(KeySerializer.INSTANCE).add(ConfigItemSerializer.INSTANCE).add(ConfigItemCollectionSerializer.INSTANCE).add(LoreSerializer.INSTANCE).add(LocaleSerializer.INSTANCE).add(ConditionsDefinitionSerializer.INSTANCE).add(TriggersDefinitionSerializer.INSTANCE);
        RegistryKey registryKey = RegistryKey.BLOCK;
        Intrinsics.checkNotNullExpressionValue(registryKey, "BLOCK");
        SerdesPackBuilder serdesPackBuilder2 = serdesPackBuilder.add((ObjectSerializer)new KeyedSerializer<BlockType>(registryKey, BlockType.class));
        RegistryKey registryKey2 = RegistryKey.BIOME;
        Intrinsics.checkNotNullExpressionValue(registryKey2, "BIOME");
        return serdesPackBuilder2.add((ObjectSerializer)new KeyedSerializer<Biome>(registryKey2, Biome.class)).add(SpawnDefinitionSerializer.INSTANCE);
    }

    private final SpawnConfig readSpawnConfig() {
        SpawnConfig spawnConfig = ConfigManager.create(SpawnConfig.class, arg_0 -> Recipes.readSpawnConfig$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(spawnConfig, "create(...)");
        return spawnConfig;
    }

    public void onLoad() {
        Companion.setInstance(this);
    }

    public final void reload() {
        Companion.setRecipesConfig(this.readConfig());
        Companion.setGuiConfig(this.readGuiConfig());
        Companion.setSpawnConfig(this.readSpawnConfig());
    }

    private static final void readConfig$lambda$0(Recipes this$0, OkaeriConfig it) {
        OkaeriSerdesPack[] okaeriSerdesPackArray = new OkaeriSerdesPack[]{this$0.configSerializers().build()};
        it.withConfigurer(new YamlBukkitConfigurer(), okaeriSerdesPackArray);
        it.withBindFile(new File(this$0.getDataFolder(), "config.yml"));
        it.saveDefaults();
        it.load(true);
        it.save();
    }

    private static final void readGuiConfig$lambda$0(Recipes this$0, OkaeriConfig it) {
        OkaeriSerdesPack[] okaeriSerdesPackArray = new OkaeriSerdesPack[]{this$0.configSerializers().build()};
        it.withConfigurer(new YamlBukkitConfigurer(), okaeriSerdesPackArray);
        it.withBindFile(new File(this$0.getDataFolder(), "gui.yml"));
        it.saveDefaults();
        it.load(true);
        it.save();
    }

    private static final void readSpawnConfig$lambda$0(Recipes this$0, OkaeriConfig it) {
        OkaeriSerdesPack[] okaeriSerdesPackArray = new OkaeriSerdesPack[]{this$0.configSerializers().build()};
        it.withConfigurer(new YamlBukkitConfigurer(), okaeriSerdesPackArray);
        it.withBindFile(new File(this$0.getDataFolder(), "spawning.yml"));
        it.saveDefaults();
        it.load(true);
        it.save();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010&\u001a\u00020'2\u0006\u0010&\u001a\u00020$J\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/jsinco/recipes/Recipes$Companion;", "", "<init>", "()V", "instance", "Ldev/jsinco/recipes/Recipes;", "getInstance", "()Ldev/jsinco/recipes/Recipes;", "setInstance", "(Ldev/jsinco/recipes/Recipes;)V", "recipesConfig", "Ldev/jsinco/recipes/configuration/RecipesConfig;", "getRecipesConfig", "()Ldev/jsinco/recipes/configuration/RecipesConfig;", "setRecipesConfig", "(Ldev/jsinco/recipes/configuration/RecipesConfig;)V", "guiConfig", "Ldev/jsinco/recipes/configuration/GuiConfig;", "getGuiConfig", "()Ldev/jsinco/recipes/configuration/GuiConfig;", "setGuiConfig", "(Ldev/jsinco/recipes/configuration/GuiConfig;)V", "spawnConfig", "Ldev/jsinco/recipes/configuration/SpawnConfig;", "getSpawnConfig", "()Ldev/jsinco/recipes/configuration/SpawnConfig;", "setSpawnConfig", "(Ldev/jsinco/recipes/configuration/SpawnConfig;)V", "recipeViewManager", "Ldev/jsinco/recipes/core/RecipeViewManager;", "getRecipeViewManager", "()Ldev/jsinco/recipes/core/RecipeViewManager;", "setRecipeViewManager", "(Ldev/jsinco/recipes/core/RecipeViewManager;)V", "recipeMap", "", "", "Ldev/jsinco/recipes/core/BreweryRecipe;", "key", "Lorg/bukkit/NamespacedKey;", "recipes", "Recipes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Recipes getInstance() {
            Recipes recipes = instance;
            if (recipes != null) {
                return recipes;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final void setInstance(@NotNull Recipes recipes) {
            Intrinsics.checkNotNullParameter((Object)recipes, "<set-?>");
            instance = recipes;
        }

        @NotNull
        public final RecipesConfig getRecipesConfig() {
            RecipesConfig recipesConfig = Recipes.recipesConfig;
            if (recipesConfig != null) {
                return recipesConfig;
            }
            Intrinsics.throwUninitializedPropertyAccessException("recipesConfig");
            return null;
        }

        public final void setRecipesConfig(@NotNull RecipesConfig recipesConfig) {
            Intrinsics.checkNotNullParameter(recipesConfig, "<set-?>");
            Recipes.recipesConfig = recipesConfig;
        }

        @NotNull
        public final GuiConfig getGuiConfig() {
            GuiConfig guiConfig = Recipes.guiConfig;
            if (guiConfig != null) {
                return guiConfig;
            }
            Intrinsics.throwUninitializedPropertyAccessException("guiConfig");
            return null;
        }

        public final void setGuiConfig(@NotNull GuiConfig guiConfig) {
            Intrinsics.checkNotNullParameter(guiConfig, "<set-?>");
            Recipes.guiConfig = guiConfig;
        }

        @NotNull
        public final SpawnConfig getSpawnConfig() {
            SpawnConfig spawnConfig = Recipes.spawnConfig;
            if (spawnConfig != null) {
                return spawnConfig;
            }
            Intrinsics.throwUninitializedPropertyAccessException("spawnConfig");
            return null;
        }

        public final void setSpawnConfig(@NotNull SpawnConfig spawnConfig) {
            Intrinsics.checkNotNullParameter(spawnConfig, "<set-?>");
            Recipes.spawnConfig = spawnConfig;
        }

        @NotNull
        public final RecipeViewManager getRecipeViewManager() {
            RecipeViewManager recipeViewManager = Recipes.recipeViewManager;
            if (recipeViewManager != null) {
                return recipeViewManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException("recipeViewManager");
            return null;
        }

        public final void setRecipeViewManager(@NotNull RecipeViewManager recipeViewManager) {
            Intrinsics.checkNotNullParameter(recipeViewManager, "<set-?>");
            Recipes.recipeViewManager = recipeViewManager;
        }

        @NotNull
        public final NamespacedKey key(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            if (StringsKt.contains$default((CharSequence)key, ":", false, 2, null)) {
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)key);
                if (namespacedKey == null) {
                    namespacedKey = new NamespacedKey("brewery_recipes", key);
                }
                return namespacedKey;
            }
            return new NamespacedKey("brewery_recipes", key);
        }

        @NotNull
        public final Map<String, BreweryRecipe> recipes() {
            if (recipeMap != null) {
                Map map = recipeMap;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("recipeMap");
                    map = null;
                }
                if (!map.isEmpty()) {
                    Map map2 = recipeMap;
                    if (map2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("recipeMap");
                        map2 = null;
                    }
                    return map2;
                }
            }
            List list = this.getInstance().loadRecipeProvider();
            Intrinsics.checkNotNull(list);
            recipeMap = MapsKt.toMap(SequencesKt.map(CollectionsKt.asSequence(list), Companion::recipes$lambda$0));
            Map map = recipeMap;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException("recipeMap");
                map = null;
            }
            return map;
        }

        private static final Pair recipes$lambda$0(BreweryRecipe it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return TuplesKt.to(it.getIdentifier(), it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

