/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.constants;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.dre.brewery.BreweryPlugin;
import dev.jsinco.brewery.garden.BreweryGarden;
import dev.jsinco.brewery.garden.constants.GenericPlantType;
import dev.jsinco.brewery.garden.utility.PlayerSkinUtil;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class PlantType
extends GenericPlantType {
    public static final PlantType BERRY = new PlantType("<dark_purple>Berry", PlayerSkinUtil.fromHashCode("1e4883a1e22c324e753151e2ac424c74f1cc646eec8ea0db3420f1dd1d8b"));
    public static final PlantType STRAWBERRY = new PlantType("<red>Strawberry", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWM5YTgzMTVmZGMzMDdiODMxNTkxOGVlYWU3ZGQ4NDI2OTEwNGIzZDliZDc3OWZjMmJhNzc5NTE1YjgwMjE0ZCJ9fX0=");
    public static final PlantType LEMON = new PlantType("<yellow>Lemon", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDM3OGI1ODJkMTljY2M1NWIwMjNlYjgyZWRhMjcxYmFjNDc0NGZhMjAwNmNmNWUxOTAyNDZlMmI0ZDVkIn19fQ==");
    public static final PlantType LIME = new PlantType("<green>Lime", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2YyNGI3MTM1Nzg5ZmU3OTlkZjM0NTk0ZDY4MDVmNTExMmJlZTYyMzI2MDViYTZkZTIxNTE4NmFkOTQifX19");
    public static final PlantType ORANGE = new PlantType("<#FFA500>Orange", PlayerSkinUtil.fromHashCode("65b1db547d1b7956d4511accb1533e21756d7cbc38eb64355a2626412212"));
    public static final PlantType GRAPE = new PlantType("<#6f2da8>Grape", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODRjZWRiOTY4NjQ1ZTI0M2U1YWRhZWIxODY4Njk2YTY3M2I5MDdhNjc4NDE4ODA3MWI2M2QxZmE5Y2Q3YjUifX19");
    public static final PlantType APPLE = new PlantType("<dark_red>Apple", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2JiMzExZjNiYTFjMDdjM2QxMTQ3Y2QyMTBkODFmZTExZmQ4YWU5ZTNkYjIxMmEwZmE3NDg5NDZjMzYzMyJ9fX0=");
    public static final PlantType PEACH = new PlantType("<#FCCCC4>Peach", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmFkYmJhYjM4ODFhYWNiYTU3N2UyN2JiZWUxZmJlNGI5YTUwZTE5ZjVhODdmOGQ0OWI2MzYwNTRmYTE3ODhmYyJ9fX0=");
    public static final PlantType CRANBERRY = new PlantType("<#791826>Cranberry", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWI0N2UwNjc3MzY3NzgwYjc2NTNkY2ViZjhjZjg4YmViNGRhYzk0Yzk4ZTY0NDYzNzVjYjVlYzhlOWEzOGRiNCJ9fX0=");
    public static final PlantType BLUEBERRY = new PlantType("<#4f86f7>Blueberry", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDI2OTdmM2VmOGY0NjI5YjY0NWZkMmU2NDQ2NDEzMjRhMWMxMTgzNTQ5OGU2MzhmNzU3ZjI3OGFmYmNlNWRiMSJ9fX0=");
    public static final PlantType CHERRY = new PlantType("<#461a27>Cherry", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGVlOTdhMDhhZDA1NGI4MDY4NGU3NmYxMzI5ZGRkMGIxZmEyNzNiMDY5OWVlODZiMjEzNzk3MDRmNzQ2OGNhIn19fQ==");
    private static final UUID CONSTANT_UUID = UUID.fromString("f714a407-f7c9-425c-958d-c9914aeac05c");
    private static final NamespacedKey PERSISTENT_DATA_KEY = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "plant");
    private static final Random RANDOM = new Random();
    private String FIELD_NAME;
    private final String base64;
    private static final Map<String, PlantType> VALUES = new HashMap<String, PlantType>();

    private PlantType(String name, String skin) {
        super(MiniMessage.miniMessage().deserialize((Object)("<!i>" + name)));
        this.base64 = skin;
    }

    public void setSkullTexture(Block block) {
        Skull skull = (Skull)block.getState();
        skull.setPlayerProfile(this.getPlayerProfile());
        skull.update();
    }

    @Override
    public ItemStack getItemStack(int amount) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD, amount);
        item.setData(DataComponentTypes.CUSTOM_NAME, (Object)this.name);
        item.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)this.getPlayerProfile()));
        item.setData(DataComponentTypes.CONSUMABLE, (Object)((Consumable)Consumable.consumable().hasConsumeParticles(false).build()));
        item.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)FoodProperties.food().nutrition(3).saturation(2.0f).build()));
        ItemMeta meta = item.getItemMeta();
        meta.lore(List.of((TextComponent)Component.text((String)"A sweet fruit").color((TextColor)NamedTextColor.DARK_GRAY)));
        meta.getPersistentDataContainer().set(PERSISTENT_DATA_KEY, PersistentDataType.STRING, (Object)this.FIELD_NAME);
        item.setItemMeta(meta);
        return item;
    }

    public void setDataOnPlayerSkullBlock(Block block) {
        if (block.getType() != Material.PLAYER_HEAD) {
            return;
        }
        Skull skull = (Skull)block.getState();
        skull.getPersistentDataContainer().set(PERSISTENT_DATA_KEY, PersistentDataType.STRING, (Object)this.FIELD_NAME);
        skull.update();
    }

    public static boolean isPlayerSkullBlock(Block block) {
        if (block.getType() != Material.PLAYER_HEAD) {
            return false;
        }
        Skull skull = (Skull)block.getState();
        return skull.getPersistentDataContainer().has(PERSISTENT_DATA_KEY);
    }

    private PlayerProfile getPlayerProfile() {
        PlayerProfile profile = Bukkit.createProfile((UUID)CONSTANT_UUID);
        profile.getProperties().add(new ProfileProperty("textures", this.base64));
        return profile;
    }

    public static boolean isPlant(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(PERSISTENT_DATA_KEY, PersistentDataType.STRING);
    }

    @Nullable
    public static PlantType getPlantType(ItemStack item) {
        if (!PlantType.isPlant(item)) {
            return null;
        }
        String field_name = (String)item.getItemMeta().getPersistentDataContainer().get(PERSISTENT_DATA_KEY, PersistentDataType.STRING);
        if (field_name == null) {
            return null;
        }
        return PlantType.valueOf(field_name);
    }

    @Nullable
    public static PlantType getPlantType(Block block) {
        if (block.getType() != Material.PLAYER_HEAD) {
            return null;
        }
        Skull skull = (Skull)block.getState();
        String field_name = (String)skull.getPersistentDataContainer().get(PERSISTENT_DATA_KEY, PersistentDataType.STRING);
        if (field_name == null) {
            return null;
        }
        return PlantType.valueOf(field_name);
    }

    public static PlantType valueOf(String name) {
        return VALUES.get(name);
    }

    public static List<PlantType> values() {
        return VALUES.values().stream().toList();
    }

    @Override
    public String toString() {
        return this.FIELD_NAME;
    }

    @Override
    public String name() {
        return this.FIELD_NAME;
    }

    public String getFIELD_NAME() {
        return this.FIELD_NAME;
    }

    public String getBase64() {
        return this.base64;
    }

    static {
        for (Field field : PlantType.class.getDeclaredFields()) {
            if (field.getType() != PlantType.class) continue;
            try {
                PlantType plantType = (PlantType)field.get(null);
                plantType.FIELD_NAME = field.getName();
                VALUES.put(field.getName(), plantType);
            }
            catch (IllegalAccessException e) {
                BreweryGarden.getInstance().getAddonLogger().severe("Failed to get field reflectively.", (Throwable)e);
            }
        }
    }
}

