/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden.constants;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.util.Vector;

public enum PlantPart {
    BOTTOM(0, -1, 0, Material.OAK_FENCE),
    MIDDLE(0, 0, 0, Material.OAK_LEAVES),
    TOP(0, 1, 0, Material.PLAYER_HEAD);

    private final int offsetCenterX;
    private final int offsetCenterY;
    private final int offsetCenterZ;
    private final Material assigneeMaterial;

    private PlantPart(int offsetCenterX, int offsetCenterY, int offsetCenterZ, Material assigneeMaterial) {
        this.offsetCenterX = offsetCenterX;
        this.offsetCenterY = offsetCenterY;
        this.offsetCenterZ = offsetCenterZ;
        this.assigneeMaterial = assigneeMaterial;
    }

    public Location locationFromCenter(Location center) {
        return center.clone().add((double)this.offsetCenterX, (double)this.offsetCenterY, (double)this.offsetCenterZ);
    }

    public Location locationFromCenter(Vector center, World world) {
        return center.clone().add(new Vector(this.offsetCenterX, this.offsetCenterY, this.offsetCenterZ)).toLocation(world);
    }

    public int getOffsetCenterX() {
        return this.offsetCenterX;
    }

    public int getOffsetCenterY() {
        return this.offsetCenterY;
    }

    public int getOffsetCenterZ() {
        return this.offsetCenterZ;
    }

    public Material getAssigneeMaterial() {
        return this.assigneeMaterial;
    }
}

