/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden;

import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.interfaces.ExternallyAutoSavable;
import com.dre.brewery.utility.Logging;
import dev.jsinco.brewery.garden.objects.GardenPlant;
import dev.jsinco.brewery.garden.persist.AutoSavableGardenPlant;
import dev.jsinco.brewery.garden.persist.SerializableGardenPlant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class GardenManager {
    private List<GardenPlant> gardenPlants = new ArrayList<GardenPlant>();
    private AutoSavableGardenPlant autoSavableInstance = new AutoSavableGardenPlant(this);

    public GardenManager(DataManager dataManager) {
        dataManager.registerAutoSavable((ExternallyAutoSavable)this.autoSavableInstance);
        List serializableGardenPlants = dataManager.getAllGeneric("gardenplants", SerializableGardenPlant.class);
        for (SerializableGardenPlant serializableGardenPlant : serializableGardenPlants) {
            this.gardenPlants.add(serializableGardenPlant.toGardenPlant());
        }
    }

    @Nullable
    public GardenPlant getByID(UUID id) {
        if (id == null) {
            return null;
        }
        for (GardenPlant plant : this.gardenPlants) {
            if (!plant.getId().equals(id)) continue;
            return plant;
        }
        return null;
    }

    @Nullable
    public GardenPlant getByLocation(Block l) {
        if (l == null) {
            return null;
        }
        for (GardenPlant plant : this.gardenPlants) {
            if (!plant.getRegion().getBlocks().contains(l)) continue;
            return plant;
        }
        return null;
    }

    public void validatePlants() {
        this.gardenPlants.forEach(gardenPlant -> {
            if (!gardenPlant.isValid()) {
                this.removePlant((GardenPlant)gardenPlant);
            }
        });
    }

    public void addPlant(GardenPlant plant) {
        Logging.debugLog((String)("Added GardentPlant:" + String.valueOf(plant)));
        plant.place();
        this.gardenPlants.add(plant);
    }

    public void removePlant(GardenPlant plant) {
        Logging.debugLog((String)("Removed GardentPlant:" + String.valueOf(plant)));
        plant.unPlace();
        this.gardenPlants.remove(plant);
    }

    public List<GardenPlant> getGardenPlants() {
        return this.gardenPlants;
    }

    public AutoSavableGardenPlant getAutoSavableInstance() {
        return this.autoSavableInstance;
    }

    public void setGardenPlants(List<GardenPlant> gardenPlants) {
        this.gardenPlants = gardenPlants;
    }

    public void setAutoSavableInstance(AutoSavableGardenPlant autoSavableInstance) {
        this.autoSavableInstance = autoSavableInstance;
    }
}

