/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.garden;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonInfo;
import com.dre.brewery.api.addons.BreweryAddon;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.utility.MinecraftVersion;
import dev.jsinco.brewery.garden.GardenManager;
import dev.jsinco.brewery.garden.commands.AddonCommandManager;
import dev.jsinco.brewery.garden.constants.PlantType;
import dev.jsinco.brewery.garden.constants.PlantTypeSeeds;
import dev.jsinco.brewery.garden.events.EventListeners;
import dev.jsinco.brewery.garden.integration.BreweryGardenPluginItem;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

@AddonInfo(name="BreweryGarden", version="BX3.4.10", author="Jsinco", description="Adds plants to BreweryX, lightweight ExoticGarden.")
public final class BreweryGarden
extends BreweryAddon {
    private static BreweryGarden instance;
    private static GardenManager gardenManager;
    private static int taskID;

    public void onAddonPreEnable() {
        instance = this;
        PluginItem.registerForConfig((String)"garden", BreweryGardenPluginItem::new);
    }

    public void onAddonEnable() {
        if (!this.isPaper() || !BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_21)) {
            this.getAddonLogger().severe("This addon can only be run on Paper 1.21.3+");
            this.getAddonManager().unloadAddon((BreweryAddon)this);
            return;
        }
        gardenManager = new GardenManager(this.getDataManager());
        this.registerListener(new EventListeners(gardenManager));
        this.registerCommand("garden", new AddonCommandManager());
        taskID = this.getScheduler().runTaskTimer((Runnable)new PlantGrowthRunnable(gardenManager), 1L, 6000L).getTaskId();
        this.registerPlantRecipes();
    }

    public void onAddonDisable() {
        this.unregisterListeners();
        this.unregisterCommands();
        Bukkit.getScheduler().cancelTask(taskID);
    }

    public void onBreweryReload() {
    }

    private void registerPlantRecipes() {
        for (PlantTypeSeeds plantTypeSeeds : PlantTypeSeeds.values()) {
            PlantType plantType = plantTypeSeeds.getParent();
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.getBreweryPlugin(), plantType.name());
            if (Bukkit.getRecipe((NamespacedKey)namespacedKey) != null) {
                Bukkit.removeRecipe((NamespacedKey)namespacedKey);
            }
            ShapelessRecipe recipe = new ShapelessRecipe(namespacedKey, plantTypeSeeds.getItemStack(4));
            recipe.addIngredient(plantType.getItemStack(1));
            Bukkit.addRecipe((Recipe)recipe);
        }
    }

    public static BreweryGarden getInstance() {
        return instance;
    }

    public static GardenManager getGardenManager() {
        return gardenManager;
    }

    public static class PlantGrowthRunnable
    implements Runnable {
        private final GardenManager gardenManager;
        private final Random random = new Random();

        public PlantGrowthRunnable(GardenManager gardenManager) {
            this.gardenManager = gardenManager;
        }

        @Override
        public void run() {
            ArrayList toRemove = new ArrayList();
            this.gardenManager.getGardenPlants().forEach(gardenPlant -> {
                if (!gardenPlant.isValid()) {
                    toRemove.add(gardenPlant);
                } else if (this.random.nextInt(100) > 20) {
                    gardenPlant.incrementGrowthStage(1);
                }
                if (gardenPlant.isFullyGrown()) {
                    if (gardenPlant.isValid()) {
                        gardenPlant.place();
                    } else {
                        toRemove.add(gardenPlant);
                    }
                }
            });
            toRemove.forEach(this.gardenManager::removePlant);
        }
    }
}

