/*
 * Decompiled with CFR 0.152.
 */
package org.whitelistapprove.whitelistApprove.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.whitelistapprove.whitelistApprove.WhitelistApprove;

public class ConfigFile
extends YamlConfiguration {
    private final WhitelistApprove plugin;
    private File file;
    private static final List<ConfigFile> configs = new ArrayList<ConfigFile>();

    public ConfigFile(WhitelistApprove plugin, String filename) {
        this.plugin = plugin;
        try {
            this.createOrLoadConfig(filename);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        configs.add(this);
    }

    public void createOrLoadConfig(String filename) throws IOException, InvalidConfigurationException {
        this.file = new File(this.plugin.getDataFolder(), filename);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource(filename, false);
        }
        this.load(this.file);
    }

    public void save() {
        try {
            this.save(this.file);
            this.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.load(this.file);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException ignored) {
            try {
                this.createOrLoadConfig(this.file.getName());
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public static void reloadAll() {
        for (ConfigFile config : configs) {
            config.reload();
        }
    }
}

