/*
 * Decompiled with CFR 0.152.
 */
package org.whitelistapprove.whitelistApprove.commands.subcommands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubcommandBase {
    private static final List<SubcommandBase> registeredCommands = new ArrayList<SubcommandBase>();
    private final String commandName;
    private String permission = null;
    private boolean playersOnly = false;

    public SubcommandBase(@NotNull String commandName) {
        this.commandName = commandName;
        this.registerCommand();
    }

    public SubcommandBase(@NotNull String commandName, String permission) {
        this(commandName);
        this.permission = permission;
    }

    public SubcommandBase(@NotNull String commandName, String permission, boolean playersOnly) {
        this(commandName, permission);
        this.playersOnly = playersOnly;
    }

    public void registerCommand() {
        registeredCommands.add(this);
    }

    public static List<SubcommandBase> getRegisteredCommands() {
        return registeredCommands;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission(CommandSender commandSender) {
        return this.getPermission() == null || this.getPermission() != null && commandSender.hasPermission(this.getPermission());
    }

    @Nullable
    public static SubcommandBase getSubCommand(String subCommand) {
        for (SubcommandBase registered : registeredCommands) {
            if (!registered.getCommandName().equals(subCommand)) continue;
            return registered;
        }
        return null;
    }

    public abstract boolean onCommand(@NotNull CommandSender var1, @NotNull String[] var2);
}

