/*
 * Decompiled with CFR 0.152.
 */
package org.whitelistapprove.whitelistApprove.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whitelistapprove.whitelistApprove.WhitelistApprove;
import org.whitelistapprove.whitelistApprove.commands.subcommands.SubcommandBase;

public class WhitelistApproveCommand
implements CommandExecutor,
TabCompleter {
    private final WhitelistApprove plugin;

    public WhitelistApproveCommand(WhitelistApprove plugin) {
        PluginCommand command = WhitelistApprove.getInstance().getCommand("whitelistapprove");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
        }
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        SubcommandBase subCommand = SubcommandBase.getSubCommand(args[0]);
        if (subCommand != null) {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            if (!subCommand.hasPermission(commandSender)) {
                commandSender.sendMessage("no permissions");
                return true;
            }
            return subCommand.onCommand(commandSender, newArgs);
        }
        commandSender.sendMessage("unknown command");
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> matches = new ArrayList<String>();
        if (args.length == 1) {
            for (SubcommandBase subCommand : SubcommandBase.getRegisteredCommands()) {
                if (!subCommand.hasPermission(commandSender)) continue;
                matches.add(subCommand.getCommandName());
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], matches, new ArrayList());
        }
        return Collections.emptyList();
    }
}

