/*
 * Decompiled with CFR 0.152.
 */
package org.limitedlives.limitedLives.listeners;

import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.limitedlives.limitedLives.LimitedLives;

public class PlayerDeathListener
implements Listener {
    private final LimitedLives plugin;

    public PlayerDeathListener(LimitedLives plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Map<UUID, Integer> playerLives = this.plugin.getPlayerLives();
        Integer livesRemaining = null;
        if (playerLives.containsKey(uuid)) {
            livesRemaining = playerLives.get(uuid);
            livesRemaining = livesRemaining - 1;
            playerLives.put(uuid, livesRemaining);
            if (livesRemaining < 0) {
                player.setGameMode(GameMode.SPECTATOR);
                return;
            }
        } else {
            this.plugin.getLogger().warning("Something went wrong, playerLives map should have contained player UUID before his death");
        }
        Component deathMessage = Component.text((String)("You have " + livesRemaining + " lives remaining.")).color(TextColor.color((int)0xFF0003));
        player.sendMessage(deathMessage);
    }
}

