/*
 * Decompiled with CFR 0.152.
 */
package org.limitedlives.limitedLives.commands;

import java.util.Map;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.limitedlives.limitedLives.LimitedLives;

public class SetLivesCommand
implements CommandExecutor {
    private final LimitedLives plugin;

    public SetLivesCommand(LimitedLives plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int newLives;
        if (!sender.hasPermission("permission.node")) {
            sender.sendMessage("permission-message");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage("Usage: /setinitiallives <lives>");
            return true;
        }
        String livesArg = args[0];
        int prevLives = this.plugin.getMaxLives();
        try {
            newLives = Integer.parseInt(livesArg);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("Usage: /setinitiallives <lives>");
            return true;
        }
        Map<UUID, Integer> playerLives = this.plugin.getPlayerLives();
        playerLives.replaceAll((uuid, integer) -> integer == prevLives ? newLives : integer);
        return true;
    }
}

