/*
 * Decompiled with CFR 0.152.
 */
package org.limitedlives.limitedLives.commands;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.limitedlives.limitedLives.LimitedLives;

public class BuyLifeCommand
implements CommandExecutor {
    private LimitedLives plugin;

    public BuyLifeCommand(LimitedLives plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage("This command can only be run by a player.");
            return true;
        }
        Player player = (Player)commandSender;
        if (strings.length == 0) {
            if (!this.checkHeldItem(player)) {
                commandSender.sendMessage("Wrong item held in hand or not enough.");
                commandSender.sendMessage("Cost: " + this.plugin.getResourceValue() + " " + this.plugin.getResourceType());
                return true;
            }
            this.plugin.increasePlayerLife(player);
            return true;
        }
        if (strings.length == 1) {
            String otherPlayerName = strings[0];
            Player otherPlayer = Bukkit.getPlayerExact((String)otherPlayerName);
            if (otherPlayer == null) {
                commandSender.sendMessage("Player not found.");
                return true;
            }
            if (!this.checkHeldItem(player)) {
                commandSender.sendMessage("Wrong item held in hand or not enough.");
                commandSender.sendMessage("Cost: " + this.plugin.getResourceValue() + " " + this.plugin.getResourceType());
                return true;
            }
            this.plugin.increasePlayerLife(otherPlayer);
            return true;
        }
        commandSender.sendMessage("Usage: /buylife <player>");
        return true;
    }

    public boolean checkHeldItem(Player player) {
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        int stackAmount = heldItem.getAmount();
        String itemType = heldItem.getType().toString();
        if (itemType.equals(this.plugin.getResourceType()) && stackAmount >= this.plugin.getResourceValue()) {
            player.getInventory().setItemInMainHand(stackAmount - this.plugin.getResourceValue() == 0 ? new ItemStack(Material.AIR, 1) : new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)this.plugin.getResourceType())), stackAmount - this.plugin.getResourceValue()));
            return true;
        }
        return false;
    }
}

