/*
 * Decompiled with CFR 0.152.
 */
package org.limitedlives.limitedLives;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.limitedlives.limitedLives.DataHandler;
import org.limitedlives.limitedLives.commands.BuyLifeCommand;
import org.limitedlives.limitedLives.commands.LivesLeftCommand;
import org.limitedlives.limitedLives.commands.SetLivesCommand;
import org.limitedlives.limitedLives.commands.SetResourceCommand;
import org.limitedlives.limitedLives.listeners.PlayerDeathListener;
import org.limitedlives.limitedLives.listeners.PlayerJoinListener;

public final class LimitedLives
extends JavaPlugin {
    private DataHandler dataHandler;
    private int initialLives = 2;
    private String resourceType = "DIAMOND";
    private int resourceValue = 10;

    public void onEnable() {
        this.dataHandler = new DataHandler(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getCommand("setinitiallives").setExecutor((CommandExecutor)new SetLivesCommand(this));
        this.getCommand("livesleft").setExecutor((CommandExecutor)new LivesLeftCommand(this));
        this.getCommand("buylife").setExecutor((CommandExecutor)new BuyLifeCommand(this));
        this.getCommand("setresource").setExecutor((CommandExecutor)new SetResourceCommand(this));
        this.load();
    }

    public void onDisable() {
        this.save();
    }

    public void load() {
        this.dataHandler.load(this.initialLives);
    }

    public void save() {
        try {
            this.dataHandler.save();
        }
        catch (IOException e) {
            this.getLogger().warning(e.toString());
        }
        this.getConfig().getKeys(false).forEach(k -> this.getConfig().set(k, null));
        this.getConfig().set("initialLives", (Object)this.initialLives);
        this.getConfig().set("resourceType", (Object)this.resourceType);
        this.getConfig().set("resourceValue", (Object)this.resourceValue);
        this.saveConfig();
    }

    public Map<UUID, Integer> getPlayerLives() {
        return this.dataHandler.getLives();
    }

    public int getMaxLives() {
        return this.initialLives;
    }

    public void setInitialLives(int newInitial) {
        this.initialLives = newInitial;
    }

    public void increasePlayerLife(Player player) {
        Map<UUID, Integer> playerLives = this.getPlayerLives();
        UUID uuid = player.getUniqueId();
        int lives = playerLives.get(uuid);
        playerLives.put(uuid, lives + 1);
        if (player.getGameMode() == GameMode.SPECTATOR) {
            Location respawnLocation = player.getRespawnLocation();
            if (respawnLocation == null) {
                respawnLocation = player.getWorld().getSpawnLocation();
            }
            player.teleport(respawnLocation);
            player.setGameMode(GameMode.SURVIVAL);
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public int getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceType(String type) {
        this.resourceType = type;
    }

    public void setResourceValue(int value) {
        this.resourceValue = value;
    }
}

